import { isDef } from "./utils.service";
import cookies from "js-cookie";
const option = {
  domain: "",
  expires: 1
};
const Cookies = {
  get(key) {
    let result = cookies.get(key);
    result = isDef(result) ? result : "";
    try {
      return JSON.parse(result);
    } catch (e) {
      return result;
    }
  },
  set(key, value) {
    return cookies.set(key, value, option);
  },
  clear() {
    return Object.keys(cookies.get()).forEach(function(cookie) {
      Cookies.remove(cookie, option);
    });
  },
  remove(key) {
    return cookies.remove(key, option);
  }
};

export default Cookies;
