/*eslint-disable*/
import { stringTrim } from './utils.service';

// 判断输入内容是否为空
export function isNull(str) {
  return str === undefined || str.length === 0 || str === null;
}

// 判断输入内容去掉空格是否为空
export function isTrimNull(str) {
  if (str === undefined || str.length === 0 || str === null) {
    return true;
  }
  return stringTrim(str).length === 0;
}

// 判断日期类型是否为YYYY-MM-DD格式的类型
export function isDate(str) {
  if (!isNull(str)) {
    const reg = /^(\d{1,4})(-|\/)(\d{1,2})\2(\d{1,2})$/;
    const r = str.match(reg);
    return r !== null;
  }
}

// 判断日期类型是否为YYYY-MM-DD hh:mm:ss格式的类型
export function isDateTime(str) {
  if (!isNull(str)) {
    const reg = /^(\d{1,4})(-|\/)(\d{1,2})\2(\d{1,2}) (\d{1,2}):(\d{1,2}):(\d{1,2})$/;
    const r = str.match(reg);
    return r !== null;
  }
  return false;
}

// 判断日期类型是否为hh:mm:ss格式的类型
export function isTime(str) {
  if (!isNull(str)) {
    const reg = /^((20|21|22|23|[0-1]\d)\:[0-5][0-9])(\:[0-5][0-9])?$/;
    return reg.test(str);
  }
  return false;
}

// 校验是否合法日期
export function isValidDate(date) {
  return date instanceof Date && !isNaN(date.getTime());
}

// 判断输入的字符是否为英文字母
export function isLetter(str) {
  if (!isNull(str)) {
    const reg = /^[a-zA-Z]+$/;
    return reg.test(str);
  }
  return false;
}

// 判断输入的字符是否为整数
export function isInteger(str) {
  if (!isNull(str)) {
    const reg = /^[-+]?\d*$/;
    return reg.test(str);
  }
  return false;
}

// 判断输入的字符是否为身份证号
export function isIdNo(str) {
  if (!isNull(str)) {
    const reg = /(^\d{15}$)|(^\d{18}$)|(^\d{17}(\d|X|x)$)/;
    return reg.test(str);
  }
  return false;
}

// 判断输入的字符是否为中文姓名最少两个中文字符
export function isChineseName(str) {
  if (!isNull(str)) {
    const reg = /^[\u0391-\uFFE5\·]{2,}$/;
    return reg.test(str);
  }
  return false;
}

// 判断输入的字符是否以数字开头
export function isStartWithInteger(str) {
  if (!isNull(str)) {
    const reg = /^[0-9].*$/;
    return reg.test(str);
  }
  return false;
}

// 判断输入的字符是否为双精度
export function isDouble(str) {
  if (!isNull(str)) {
    const reg = /^[-\+]?\d+(\.\d+)?$/;
    return reg.test(str);
  }
  return false;
}

// 判断输入的字符是否为:a-z,A-Z,0-9,_,并以字母开头
export function isProgramVar(str) {
  if (!isNull(str)) {
    const reg = /^[a-zA-Z][a-zA-Z0-9_]*$/;
    return reg.test(str);
  }
  return false;
}

// 判断输入的字符是否为:a-z,A-Z,0-9,_,并以大写字母开头
export function isProgramClassName(str) {
  if (!isNull(str)) {
    const reg = /^[A-Z][a-zA-Z0-9_]*$/;
    return reg.test(str);
  }
  return false;
}

// 判断输入的字符是否为中文
export function isChinese(str) {
  if (!isNull(str)) {
    const reg = /^[\u0391-\uFFE5]+$/;
    return reg.test(str);
  }
  return false;
}

// 判断输入的EMAIL格式是否正确
export function isEmail(str) {
  if (!isNull(str)) {
    const reg = /\w[-\w.+]*@([A-Za-z0-9][-A-Za-z0-9]+\.)+[A-Za-z]{2,14}/g;
    return reg.test(str);
  }
  return false;
}

// 判断输入的邮编(只能为六位)是否正确
export function isZIP(str) {
  if (!isNull(str)) {
    const reg = /^\d{6}$/;
    return reg.test(str);
  }
}

// 判断字符串的长度是否满足条件
export function isLengthValidate(str, len) {
  if (str) {
    if (str.length <= len) {
      return true;
    } else {
      return false;
    }
  } else {
    return true;
  }
}

// 判断输入的字符是否为:a-z,A-Z,0-9,_,汉字
export function isProgramName(str) {
  if (!isNull(str)) {
    const reg = /^[a-zA-Z0-9_\u4e00-\u9fa5]+$/;
    return reg.test(str);
  }
  return false;
}

// 判断输入的字符是否为:a-z,A-Z,0-9,_,汉字
export function isProgramCode(str) {
  if (!isNull(str)) {
    const reg = /^[a-zA-Z0-9_\u4e00-\u9fa5]+$/;
    return reg.test(str);
  }
  return false;
}

// 判断输入的字符是否以http://或者https://开头，且必须是个网址
export function isProgramWeb(str) {
  if (!isNull(str)) {
    let reg = /^((https|http)?:\/\/)[^\s]+/;
    return reg.test(str);
  }
  return false;
}

export function isValueTypeMatched(type, value) {
  switch (type) {
    case 'Integer':
      if (!/^\-?\d+$/.test(value)) {
        return false;
      }
      break;
    case 'Double':
      if (!/^\-?\d+\.\d+$/.test(value)) {
        return false;
      }
      break;
    case 'Long':
      if (!/^\-?\d+$/.test(value)) {
        return false;
      }
      break;
    case 'Boolean':
      if (value !== 'true' && value !== 'false') {
        return false;
      }
      break;
    default:
      return true;
  }
  return true;
}

export function isProperties(str) {
  if (!isNull(str)) {
    let reg = /^[a-zA-Z\u4e00-\u9fa5][a-zA-Z_0-9\u4e00-\u9fa5]*\s*=\s*[a-zA-Z_0-9\u4e00-\u9fa5]+/;
    return reg.test(str);
  }
  return false;
}

// 拒绝码以大写字母开头，包含数字、大写字母、下划线，且为四段式
export function isUppercase(str) {
  const reg = /^[A-Z]([A-Z0-9]*_){1}([A-Z0-9]+_){2}[A-Z0-9]+$/;
  return reg.test(str);
}

//判断用户名
export function isUserName(str) {
  if (!isNull(str)) {
    const reg = /^[a-zA-Z\d_]{4,20}$/;
    return reg.test(str);
  }
  return false;
}

//判断密码
export function isPassword(str) {
  if (!isNull(str)) {
    const reg = /^[a-zA-Z\d]{6,14}$/;
    return reg.test(str);
  }
  return false;
}

//判断手机号
export function isPhone(str) {
  if (!isNull(str)) {
    const reg = /^1[3456789]\d{9}$/;
    return reg.test(str);
  }
  return false;
}

// 判断税号
export function isTax(str) {
  if (!isNull(str)) {
    const reg = /^[A-Z0-9]{15}$|^[A-Z0-9]{17}$|^[A-Z0-9]{18}$|^[A-Z0-9]{20}$/;
    return reg.test(str);
  }
  return false;
}

// 判断银行号
export function isBankNumber(str) {
  if (!isNull(str)) {
    const reg = /^[0-9]{16}$|^[0-9]{17}$|^[0-9]{19}$/;
    return reg.test(str);
  }
  return false;
}

// 判断中文地址不能少于5个汉字，且必须有一位数字
export function isChnAddress(str) {
  const isNum = /[0-9]\d*/;
  const isChinese_var = /[\u4e00-\u9fa5]/g;
  if (!isNull(str)) {
    return isNum.test(str) && str.match(isChinese_var).length >= 5;
  }
  return false;
}
const ua = uni.getSystemInfoSync().ua
// 判断微信环境
export const isWechat = ua.match(/MicroMessenger/i) == 'micromessenger';
// 是否信用钱包
export const isXYQB = ua.indexOf("xyqb") > -1;

// 判断微信小程序环境
export const isWxMp = uni.getSystemInfoSync().platform  ===  'mp-weixin'

// 判断羊小咩（信用钱包）环境
export const isApp = ua.match(/xyqb/i) == 'xyqb';

// 判断真享生活
export const isVcc = ua.match(/VCC/i) == 'vcc';

// 判断IOS环境
export const isIOS = /iphone|ipad|ipod/.test(ua);

// 判读Android环境
export const isAndroid = /android/.test(ua);

// 判断
export const appVersion = ua.match(/xyqb\/([\d|.]+)/) ? ua.match(/xyqb\/([\d|.]+)/)[1] : '8.8.00';

export const isQQ = ua.match(/QQ/i) == 'qq';

export const isWeiBo = ua.match(/Weibo/i) == 'weibo';

export const isDingTalk = ua.match(/DingTalk/i) == 'dingtalk';

// 判读非微信浏览器和appwebview和小程序webview
export const isH5Normal = !isWechat && !isWxMp && !isApp;
