import { mapState } from 'vuex';
import { locationHrefPatch } from '@/service/utils.service';
import { sStorage } from '@/service/sessionStorage.service';
import localStorage from '@/service/localStorage.service';
export default {
  methods: {
    mxHandleToDetails({ item, area, index, urlKey }) {
      const jumpUrl = this.formatUrl(
        item[urlKey] || item.jumpUrl || item.coverJumpUrl || item.floorJumpUrl
      );
      locationHrefPatch(jumpUrl, this.$router);
      console.log('DEBUG: toDetails ====>', item, area, index);
    },
    formatUrl(url) {
      if (url && url.indexOf('://quantum-h5') > -1) {
        // 量子积木url增加数美ID键，feat: 量子积木领券数美埋点; PM: 崔倩倩
        const shumeiKey = sStorage.getItem('shumeiKey');
        if (shumeiKey) url = this.addParamToURL(url, 'shumeiKey', shumeiKey);
      }

      return url
        ?.replace(/\{vccToken\}/g, localStorage.get('vccToken'))
        ?.replace(/\{token\}/g, localStorage.get('vccToken'))
        ?.replace(/\{registerFrom\}/g, localStorage.get('vccChannel') || '')
        ?.replace(/\{tenantId\}/g, localStorage.get('tenantId') || '560761')
        ?.replace(/\{appChannel\}/g, localStorage.get('appChannel') || '')
        ?.replace(/\{phone\}/g, this.userInfo.phoneNumber);
    },
    addParamToURL(url, key, value) {
      let newUrl = url.indexOf('?') < 0 ? url + '?' : url + '&';
      return newUrl + key + '=' + value;
    }
  },
  computed: {
    ...mapState({
      userInfo: state => {
        return (state && state.pay.userInfo) || {};
      },
      smDeviceId: state => state.pay.smDeviceId
    })
  }
};
