const fs = require("fs");
const path = require("path");
const less = require("less");

// 设置需要转换的目录路径和输出目录路径
const srcDir = "./source";
const outDir = "./out";

// 递归遍历 srcDir 目录下的所有 less 文件，并进行转换
const convertLessToScss = (dir, out) => {
  const files = fs.readdirSync(dir);
  for (const file of files) {
    const filePath = path.join(dir, file);
    const stat = fs.statSync(filePath);
    if (stat.isDirectory()) {
      convertLessToScss(filePath, path.join(out, file));
    } else if (stat.isFile() && path.extname(file) === ".less") {
      const scss = convertLessFile(filePath);
      const outPath = path.join(out, path.basename(file, ".less") + ".scss");
      fs.writeFileSync(outPath, scss);
      console.log(`Converted ${filePath} to ${outPath}`);
    }
  }
};

// 将单个 less 文件进行转换
const convertLessFile = filePath => {
  const lessContent = fs.readFileSync(filePath, "utf-8");
  return less.renderSync(lessContent, { syntax: "scss" }).css.toString();
};

// 创建输出目录
if (!fs.existsSync(outDir)) {
  fs.mkdirSync(outDir);
}

// 开始转换
convertLessToScss(srcDir, outDir);
