module.exports = {
  root: true,
  globals: {
    uni: true,
    wx: true,
    getApp: true,
    getCurrentPages: true,
    __wxConfig: true,
    Page: true
  },
  env: {
    node: true,
    browser: true
  },
  extends: [
    "plugin:vue/essential",
    "plugin:vue/recommended",
    "eslint:recommended",
    "@vue/prettier"
  ],
  parserOptions: {
    parser: "babel-eslint"
  },
  rules: {
    "prettier/prettier": "error",
    "vue/max-attributes-per-line": "off",
    "vue/html-self-closing": [
      "error",
      {
        html: {
          void: "always",
          normal: "always",
          component: "always"
        },
        svg: "always",
        math: "always"
      }
    ],
    "no-empty": ["error", { allowEmptyCatch: true }],
    "vue/no-v-html": "off",
    "vue/require-default-prop": "off",
    "arrow-parens": "off", // allow paren-less arrow functions
    "generator-star-spacing": "off", // allow async-await
    "no-unused-vars": "error", // disabled no ununsed var
    "no-debugger": process.env.NODE_ENV === "production" ? "error" : "off", // no use debugger in production
    indent: [2, 2, { SwitchCase: 1 }], // 2 space for tab for perttier
    "space-before-function-paren": ["error", "never"] // no space in function name for perttier
  }
};
