import request from '@/service/httpDecorator';
import config from '@/config';
import { saDeviceId } from '@/service/sa.service';
const { talosHost } = config;

const queryPayInfo = function(data) {
  return request.post(`${talosHost}/open/checkout`, data);
};
const prepay = async function(data) {
  const scDeviceId = await saDeviceId();
  return request.post(`${talosHost}/open/checkout/prepay`, data, {
    customHeader: {
      scDeviceId
    },
    hideToast: true
  });
};

const pay = async function(data) {
  const scDeviceId = await saDeviceId();
  return request.post(`${talosHost}/open/checkout/pay`, data, {
    customHeader: {
      scDeviceId
    },
    hideToast: true
  });
};

const queryPayStatus = function(data) {
  return request.post(`${talosHost}/open/checkout/pay_status/query`, data);
};

const sendSms = function(data) {
  return request.post(`${talosHost}/open/checkout/send_sms`, data);
};

const desSalt = function() {
  return request.get(`${talosHost}/vcc/account/salt`);
};

const h5AppyUrl = function() {
  return request.get(`${talosHost}/vcc/xyqb_mall/app_url`);
};

const getCoupon = async function(params) {
  const scDeviceId = await saDeviceId();
  return request.post(`${talosHost}/open/checkout/pay_coupon_list`, params, {
    customHeader: {
      scDeviceId
    }
  });
};

const ocrFaceId = function(params) {
  return request.post(`${talosHost}/open/checkout/ocr_faceId`, params);
};

const getGoodsList = async function(data) {
  const scDeviceId = await saDeviceId();
  return request.get(`${talosHost}/vcc/xyqb/recommend/goods-list`, {
    params: data,
    hideLoading: true,
    customHeader: {
      scDeviceId
    }
  });
};

// KA流程节点
const kaGetNextUrl = function() {
  return request.get(`${talosHost}/api/kdsp/ka/process/get-next-url`);
};

const reissueContract = function(params) {
  return request.post(`${talosHost}/open/checkout/payReissueContract`, params);
};

export default {
  // 商品详情页面
  desSalt() {
    return request.get(`${talosHost}/vcc/account/salt`);
  }
};
const getCouponList = function(params) {
  return request.get(`${talosHost}/api/kdsp/appconfig/pay-succ-page/guide-stream`, { params });
};
// 获取用户手机号
const getPhoneNumber = function() {
  return request.get(`${talosHost}/api/kdsp/user/phone`);
};
export {
  pay,
  prepay,
  sendSms,
  desSalt,
  h5AppyUrl,
  getCoupon,
  ocrFaceId,
  queryPayInfo,
  getGoodsList,
  kaGetNextUrl,
  getCouponList,
  queryPayStatus,
  reissueContract,
  getPhoneNumber
};
