import Vue from 'vue';
import sa from 'sa-sdk-javascript';
import config from '@/config';
console.log(config);
export default {
  init: function(router) {
    sa.init({
      server_url: config.shenceHost,
      heatmap: {
        // 是否开启点击图，默认 default 表示开启，自动采集 $WebClick 事件，可以设置 'not_collect' 表示关闭
        clickmap: 'default',
        // 关闭触达注意力
        scroll_notice_map: 'not_collect'
      },
      // TODO: app是如何判断的
      // 判断外层是否有 App 的 SDK ，如果有的话，会往 App 的 SDK 发数据。如果没有，就正常发送数据。
      use_app_track: false,
      show_log: config.env === 'test'
    });
    // 添加公共属性
    sa.registerPage({ platformType: 'H5' });

    router.afterEach(() => {
      Vue.nextTick(() => {
        sa.quick('autoTrackSinglePage');
      });
    });
  }
};
export function saTrackEvent(name, data) {
  sa.track(name, data);
}
export function saDeviceId() {
  return new Promise(resolve => {
    sa.quick('isReady', function() {
      resolve(sa.quick('getAnonymousID'));
    });
  });
}
// 设置公共属性
export function setRegisterPage(registerPageObj) {
  sa.registerPage(registerPageObj);
}
