export const SURE_BTN = 0;
export const TMOT_BTN = 1;
export const ZREO_BTN = 2;
export const BUTTON_CONFIG = {
  [SURE_BTN]: [
    {
      name: "确认支付",
      type: "primary",
      className: "pay__button--primary",
      event: "nextAction"
    }
  ],
  [TMOT_BTN]: [
    {
      name: "查看订单",
      type: "default",
      className: "pay__button--default",
      event: "goOrderDetail"
    },
    {
      name: "返回商城",
      type: "primary",
      className: "pay__button--primary",
      event: "goHome"
    }
  ],
  [ZREO_BTN]: [
    {
      name: "实际支付0.00",
      type: "primary",
      className: "pay__button--primary",
      event: "nextAction"
    }
  ]
};

// 1信用支付 2微信支付 3支付宝支付 4信用支付_微信支付 5信用支付_支付宝支付 6虚拟支付0元
export const CREDIT_PAY = 1;
export const WECHAT_PAY = 2;
export const ALIPAY_PAY = 3;
export const CREDIT_AND_WECHAT_PAY = 4;
export const CREDIT_AND_ALIPAY_PAY = 5;
export const VIRTUAL_PAY = 6;

// 三方支付
export const IS_THIRD_PAY = method => [WECHAT_PAY, VIRTUAL_PAY].indexOf(method) > -1;
//信用支付
export const IS_CREDIT_PAY = method => [CREDIT_AND_WECHAT_PAY, CREDIT_PAY].indexOf(method) > -1;
//组合支付
export const IS_GROUP_PAY = method => [CREDIT_AND_WECHAT_PAY].indexOf(method) > -1;

export const TACK_PAY_BUTTON_CLICK = {
  3: "支付宝支付",
  7: "百度收银台支付"
};

export const POPUPCONFIG = {
  1: {
    title: "开通享花卡",
    content: "您准备好了弹窗吗？",
    cancelTxt: "nono",
    confirmTxt: "ok",
    cancelEvent: "quxiao"
  },
  2: {
    title: "又是陵王你一个",
    content: "这是一段文字",
    hideCancelBtn: true,
    cancelEvent: "quxiao"
  },
  3: {
    content: "没有title",
    confirmEvent: "okEvent"
  },
  default: {
    title: "",
    content: "",
    duration: 2000,
    beforeClose: true,
    cancelTxt: "取消",
    confirmTxt: "确定",
    hideCancelBtn: false,
    cancelEvent: null,
    confirmEvent: null
  }
};
