/* eslint-disable space-before-function-paren */
/* eslint-disable prettier/prettier */
import request from "../utils/request";
import config from "@/config";
const { yxmGateway } = config;
// 获取banner
const getBanner = function (data) {
  ///appconfig/home/topinfo
  const page = "home";
  return request.get(`${yxmGateway}/api/kdsp/appconfig/${page}/topinfo`, data, {
    hideLoading: true
  });
};


//获取动态内容【金刚区、运营专区等】【金刚区、运营专区-横向，运营专区-竖向， 通栏】
const getContent = function (data) {
  //页面：home-精选，discovery-发现，profile-我的
  const page = "home";
  return request.get(`${yxmGateway}/api/kdsp/appconfig/${page}/content`, data, {
    hideLoading: true
  });
};

// 主页底纹词
const getSearchBorderTxt = function (data) {
  const page = "home";
  return request.get(`${yxmGateway}/api/kdsp/appconfig/${page}/border`, data, {
    hideLoading: true
  });
};
// 主页猜你喜欢列表
const getGoodsList = function (data) {
  const tenantId = +uni.getStorageSync("tenantId");
  if (tenantId === 560867) {
    // 青海移动
    return request.get(`${yxmGateway}/api/kdsp/recommend/goods-list`, data, {
      needScDeviceId: true,
      hideLoading: true
    });
  } else {
    // 羊小咩
    // return request.get(`${talosApi}/vcc/xyqb/recommend/goods-list`, data, {
    return request.get(`${yxmGateway}/api/kdsp/recommend/goods-list`, data, {
      needScDeviceId: true,
      hideLoading: true
    });
  }
};

const homeSearch = function (data, loading = true) {
  return request.post(`${yxmGateway}/api/kdsp/search/result`, data, {
    needScDeviceId: true,
    hideLoading: loading
  });
};

const getActivityInfo = function (data) {
  return request.post(`${yxmGateway}/api/kdsp/search/result/fee/calc`, data, {
    needScDeviceId: true,
    hideLoading: true
  });
};

const landingSearch = function (data) {
  return request.post(`${yxmGateway}/api/kdsp/search/result`, data, {
    needScDeviceId: true,
    hideLoading: true
  });
};

// 搜索--大家都在搜的关键词
const getTerms = function (data) {
  // return request.get(`${talosApi}/vcc/app/mall/search/page`, data);
  return request.get(`${yxmGateway}/api/kdsp/search/page`, data);
};

// 商品详情页是否放开立即购买
///api/kdsp/order-info/miniOrder/hasOrder
const hasOrder = function (data) {
  return request.get(`${yxmGateway}/api/kdsp/order-info/miniOrder/hasOrder`, data);
};

// 详情页基本信息--/api/kdsp/sku-info/detail/query
const detailInfo = function (data) {
  // return request.get('http://yapi.quantgroups.com/mock/351/api/kdsp/sku-info/detail/query')
  return request.get(`${yxmGateway}/api/kdsp/sku-info/detail/query`, data);
};

// 详情页-猜你喜欢  /vcc/xyqb/recommend/like
const goodsLike = function (data) {
  // return request.get(`${talosApi}/vcc/xyqb/jd/recommend/like`, data, {
  return request.get(`${yxmGateway}/api/kdsp/recommend/goods-detail/similarity`, data, {
    needScDeviceId: true,
    hideLoading: true
  });
};

const shopCartLike = function (data) {
  // return request.get(`${talosApi}/vcc/xyqb/jd/recommend/like`, data, {
  return request.get(`${yxmGateway}/api/kdsp/recommend/goods-list`, data, {
    needScDeviceId: true,
    hideLoading: true
  });
};

// 商品详情地址列表
const addrList = function (data) {
  return request.get(`${yxmGateway}/api/kdsp/addr/receiver/list`, data, {
    hideLoading: true
  });
};

// 商品详情优惠券列表
const getCouponList = function (data) {
  return request.get(`${yxmGateway}/api/kdsp/coupon/user-pickup`, data);
};

// 查询用户优惠券选择查询接口
const getCouponChooseList = function (data) {
  return request.post(`${yxmGateway}/api/kdsp/coupon/activity/choose-list`, data);
};

// 商品详情--领取优惠券  /api/kdsp/coupon/user-pickup
const userPickupCoupon = function (data) {
  return request.post(`${yxmGateway}/api/kdsp/coupon/pickup`, data, {
    hideLoading: true,
    reportDeviceId: true
  });
};

// 获取首页活动弹窗
const getHomePopup = function () {
  return request.get(
    `${yxmGateway}/api/kdsp/app-config-push/home/popup`,
    {
      page: "home"
    },
    {
      hideLoading: true
    }
  );
};
// 上报活动弹窗
const uploadPopup = function (data) {
  return request.post(`${yxmGateway}/api/kdsp/app-config-push/report/notice`, data, {
    hideLoading: true
  });
};

const getVaildSubTmplIds = async tmplIds => {
  const res = await wx.getSetting({
    withSubscriptions: true
  });
  let {
    subscriptionsSetting: { mainSwitch, itemSettings }
  } = res;
  if (mainSwitch) {
    itemSettings = itemSettings || {};
    const vaildTmplIds = tmplIds.filter(
      item => !itemSettings[item] || itemSettings[item] !== "ban"
    );
    return vaildTmplIds;
  }
};
const subscribe = async data => {
  return request.post(`${yxmGateway}/api/kdsp/group-msg/subscribe`, data, {
    hideLoading: true
  });
};

const addSkuToCart = function (data) {
  return request.post(`${yxmGateway}/api/kdsp/shop-cart/add-update`, data, {
    hideLoading: true
  });
};
// 获取购物车商品数量
const getCartCount = function () {
  return request.get(
    `${yxmGateway}/api/kdsp/shop-cart/count`,
    {},
    {
      hideLoading: true
    }
  );
};

// 无效商品列表
const getInvalidList = function (data) {
  return request.post(`${yxmGateway}/api/kdsp/shop-cart/list/invalid`, data, {
    hideLoading: true
  });
};

// 青海获取礼品卡余额接口
const getGiftCard = () => {
  return request.get(`${yxmGateway}/api/kdsp/user/card-coupon`);
};
// 上报数据
const importOpenId = function (data) {
  return request.post(`${yxmGateway}/api/kdsp/miniapp/saveWechatAppletInfo`, data, {
    hideLoading: true,
    hideToast: true
  });
};
// 获取卡包部分信息(羊小咩)
const getWalletInfo = function () {
  return request.get(`${yxmGateway}/api/kdsp/user/mine/my-wallet`, {
    hideLoading: true,
    hideToast: true
  });
};

const getFincialData = () => {
  return request.get(`${yxmGateway}/api/kdsp/miniapp/jump/vcc/mini`,
    {},
    {
      header: {
        appChannel: 'miniapp',
        appName: "xinyongqianbao",
        userId: uni.getStorageSync("userAuthInfo").userId,
        uuid: uni.getStorageSync("userAuthInfo").uuid
      }
    }
  );
};
const getSchemaCode = params => {
  return request.post(`${yxmGateway}/api/kdsp/miniapp/jump/vcc/mini/schema/code`, params,
    {
      header: {
        appName: "xinyongqianbao",
        userId: uni.getStorageSync("userAuthInfo").userId,
        uuid: uni.getStorageSync("userAuthInfo").uuid
      }
    });
};


const getContract = () => {
  return request.get(`${yxmGateway}/api/kdsp/contract/view`);
}

const smEvent = data => {
  return request.post(`${yxmGateway}/api/kdsp/shumei/eventDataServer/report`, data);
};

// kdsp存数美设备id
const uploadSMDeviceID = data => {
  return request.post(`${yxmGateway}/api/kdsp/fraud/borderColor`, data);
};


export {
  getSearchBorderTxt,
  getBanner,
  getContent,
  getGoodsList,
  homeSearch,
  getActivityInfo,
  getTerms,
  hasOrder,
  detailInfo,
  addrList,
  getCouponList,
  getCouponChooseList,
  userPickupCoupon,
  goodsLike,
  landingSearch,
  getCartCount,
  addSkuToCart,
  getInvalidList,
  getHomePopup,
  getVaildSubTmplIds,
  uploadPopup,
  subscribe,
  shopCartLike,
  getGiftCard,
  importOpenId,
  getWalletInfo,
  getFincialData,
  getSchemaCode,
  getContract,
  smEvent,
  uploadSMDeviceID
};
