import Vue from "vue";
import Vuex from "vuex";
import shopCart from "./modules/shoppingCart";
import qa from "./modules/qa";
import ad from "./modules/ad";
Vue.use(Vuex);
const store = new Vuex.Store({
  state: {
    hasLogin: false,
    userInfo: {},
    address: {},
    userAuthInfo: {},
    cartCount: 0
  },
  mutations: {
    login(state, provider) {
      state.hasLogin = true;
      state.userInfo = provider;
      uni.setStorage({
        //缓存用户登陆状态
        key: "userInfo",
        data: provider
      });
      console.log(state.userInfo);
    },
    logout(state) {
      state.hasLogin = false;
      state.userInfo = {};
      uni.removeStorage({
        key: "userInfo"
      });
    },
    editAddress(state, payload) {
      state.address = JSON.parse(JSON.stringify(payload));
    },
    saveUserAuthInfo(state, userAuthInfo) {
      state.userAuthInfo = userAuthInfo;
    },
    saveCartCount(state, count) {
      state.cartCount = count;
    }
  },
  actions: {},
  modules: {
    shopCart,
    qa,
    ad
  }
});

export default store;
