import request from "../utils/request";
import config from "@/config";
const { yxmGateway } = config;

// 根据id查询优惠券列表
const couponList = function(data) {
  return request.get(`${yxmGateway}/api/kdsp/coupon/h5-qb/list`, data);
};
// 用户领取优惠券接口-批量
const couponPickup = function(data) {
  return request.post(`${yxmGateway}/api/kdsp/coupon/pickup-batch`, data, {
    reportDeviceId: true
  });
};
// 搜索接口_result
const searchGoodsList = function(data) {
  return request.post(`${yxmGateway}/api/kdsp/search/result`, data);
};
// 用户领取优惠券状态查询
const searchCoupon = function(data) {
  return request.get(`${yxmGateway}/api/kdsp/coupon/pickup-status`, data);
};
// KA流程节点
const kaGetNextUrl = function(data) {
  let options = {
    sonVccChannel: true
  };
  return request.get(`${yxmGateway}/api/kdsp/ka/process/get-next-url`, data, options);
};
// KA流程节点_查询流程是否走完
const kaFlow = function(data) {
  let options = {
    sonVccChannel: true
  };
  return request.get(`${yxmGateway}/api/kdsp/ka/process/get-status`, data, options);
};
// 流程节点_返回商品页面临时支持1个月(高价)
const lableInfoIdsExpensive = function(data) {
  return request.get(`${yxmGateway}/api/kdsp/ka/process/get-landing-page-temp`, data);
};
// 获取ka配置
const getKaData = function(data) {
  return request.get(`${yxmGateway}/api/kdsp/ka/info/getDetail`, data);
};
// 验证是否是白名单
const getWhiteUser = function(data) {
  return request.get(`${yxmGateway}/api/kdsp/ka/user/getWhiteUser`, data);
};
// 根据md5获取百人团url
const getGroupBuyUrl = function(m) {
  return request.get(`${yxmGateway}/api/kdsp/playBill/getPlayBillUrl?m=${m}`);
};
export {
  searchCoupon,
  couponList,
  couponPickup,
  searchGoodsList,
  kaGetNextUrl,
  kaFlow,
  lableInfoIdsExpensive,
  getKaData,
  getWhiteUser,
  getGroupBuyUrl
};
