import http from '@/service/httpDecorator';
import config from '@/config';
const { xinchengHost, yxmGwHost } = config;

// max会员
export const maxMember = {
  // max会员邀请页接口 - 基本信息接口
  invitaionInfo: () => {
    return http.get(`${xinchengHost}/api/kdsp/maxMember/maxMemberInvitaionInfo`);
  },
  // MAX会员激活页 - 激活信息
  activateInfo: params => {
    return http.post(`${xinchengHost}/api/kdsp/maxMember/addMaxMember`, params);
  },
  // max会员详情
  memberInfo: () => {
    return http.get(`${xinchengHost}/api/kdsp/maxMember/getMaxMemberInfo`);
  },
  // 优惠券展示
  couponList: () => {
    return http.get(`${xinchengHost}/api/kdsp/max/member/coupon`);
  },
  // max会员-商品
  goodsList: params => {
    return http.get(`${xinchengHost}/api/kdsp/max/member/goods`, { params });
  },
  // 会员商品品类
  categoryList: () => {
    return http.get(`${xinchengHost}/api/kdsp/max/member/goods/category`);
  },
  // 加购接口
  addShopCart: params => {
    return http.post(`${xinchengHost}/api/kdsp/shop-cart/add-update`, params);
  },
  // 获取用户max会员和普通会员信息
  // http://yapi.quantgroups.com/project/351/interface/api/58329
  getUserAndMaxInfo: () => {
    return http.get(`${yxmGwHost}/api/kdsp/userBenefits/center/getUserAndMaxInfo`);
  }
};
