import config from '@/config';
import http from '@/service/httpDecorator';
const { yxmGwHost } = config;

export default {
  saveAddress(data) {
    return http.post(`${yxmGwHost}/api/kdsp/addr/receiver/add_edit`, data);
  },
  getAddressList() {
    return http.get(`${yxmGwHost}/api/kdsp/addr/receiver/list`);
  },
  deleteAddress(addrReceiverId) {
    return http.post(`${yxmGwHost}/api/kdsp/addr/receiver/delete`, {
      addrReceiverId
    });
  },
  // 地址级联查询
  zoneList: params => {
    return http.get(`${yxmGwHost}/api/kdsp/addr/query?addrId=${params}`);
  }
};
