import CryptoJS from 'crypto-js';
import pay from '@/api/pay.api';

/**
 * @description: 数据加密
 * @message {String} message 数据源
 * @return {String} 加密后的数据16进制
 */
export async function encryptByDESModeEBC(message) {
  console.log(message);
  const [{ payPwdSalt }] = await pay.desSalt();
  var keyHex = CryptoJS.enc.Utf8.parse(payPwdSalt);
  var encrypted = CryptoJS.DES.encrypt(message, keyHex, {
    mode: CryptoJS.mode.ECB,
    padding: CryptoJS.pad.Pkcs7
  });
  return encrypted.ciphertext.toString().toLocaleUpperCase();
}
