export default {
  // 页面卸载时触发。如wx.redirectTo或wx.navigateBack到其他页面时
  methods: {
    saveEwm() {
      const _self = this;
      uni.getSetting({
        success(res) {
          if (!res.authSetting["scope.writePhotosAlbum"]) {
            uni.authorize({
              scope: "scope.writePhotosAlbum",
              success(opt) {
                console.log(opt)
                //这里是用户同意授权后的回调
                _self.saveImage();
              },
              fail(error) {
                console.log(error);
                uni.showModal({
                  title: "温馨提示",
                  content: "保存图片功能需要您的微信授权才能使用",
                  cancelText: "不授权",
                  confirmText: "授权",
                  confirmColor: "#ec1500",
                  success: function (res) {
                    if (res.confirm) {
                      // 这个 API 是基础库 1.1.0 才有的，所以需要做兼容处理：
                      if (uni.openSetting) {
                        uni.openSetting({
                          //进入授权设置页面手动授权
                          success: function (opt) {
                            console.log(opt);
                            if (opt.authSetting['scope.writePhotosAlbum']) {
                              _self.doneSaveImage && _self.doneSaveImage();
                            } else {
                              _self.refuseSaveImage && _self.refuseSaveImage();
                            }
                          }
                        });
                      }
                      //低版本兼容  做提示操作
                      else {
                        uni.showModal({
                          title: "授权提示",
                          confirmColor: "#ec1500",
                          content:
                            "保存图片需要您的微信授权才能使用，错过授权页面的处理方法：1、删除小程序->重新搜索进入->点击授权按钮；2、可在小程序设置打开相应权限"
                        });
                      }
                    }
                    //用户继续拒绝授权。
                    else if (res.cancel) {
                      uni.showModal({
                        title: "温馨提示",
                        content:
                          "相册授权失败，错过授权页面的处理方法：1、删除小程序->重新搜索进入->点击授权按钮；2、可在小程序设置打开相应权限",
                        showCancel: false,
                        confirmColor: "#ec1500",
                        success: function () {
                          _self.refuseSaveImage && _self.refuseSaveImage();
                        }
                      });
                    }
                  }
                });
              } //这里是用户拒绝授权后的回调
            });
          } else {
            //用户已经授权过了
            _self.saveImage();
          }
        }
      });
    }
  }
};
