/**
 * 优惠券
 */
export const DISCOUNT = 1;
/**
 * 运费券
 */
export const FREIGHT = 2;
/**
 * 现金券
 */
export const CASH = 3;
/**
 * 活动优惠
 */
export const REDUCTION = 4;
/**
 * 礼品卡
 */
export const GIFT = 20;
/**
 * 是否有折扣
 */
export const HAS_DISCOUNT = 2;
/**
 *  不可用的折扣
 * @type {number}
 */
export const INVALID_DISCOUNT = 1;
export const COMB_COUPON = 9; // 组合优惠券
export const COMB_ACTIVITY = 10; // 组合活动

/**
 * 1.优惠券
 * 2.运费优惠
 * 3.现金券
 * 4.活动优惠
 * 20.礼品卡
 */
export const TITLE_LIST = {
  [DISCOUNT]: '优惠券',
  [FREIGHT]: '运费优惠',
  [CASH]: '现金券',
  [REDUCTION]: '活动优惠',
  [GIFT]: '礼品卡'
};

export const GIFT_USE = 2;

export const defaultCoupon = {
  [DISCOUNT]: 'defaultUseCoupon',
  [COMB_COUPON]: 'defaultUseCoupon',
  [FREIGHT]: 'defaultUseFreightFeeCoupon',
  [CASH]: 'defaultUseCashCoupon',
  [REDUCTION]: 'defaultUseActivityCoupon',
  [GIFT]: 'defaultUseGiftCard'
};
/**
 * 商家配送
 */
export const SHIP_BUS = -1;
/**
 * 用户自提
 */
export const SHIP_USE = 101;
