import * as types from "./type";
let appId;
//#ifdef MP-ALIPAY
appId = uni.getAppIdSync().appId;
//#endif

// #ifndef MP-ALIPAY  || H5
const accountInfo = uni.getAccountInfoSync();
appId = accountInfo.miniProgram.appId;
// #endif
const qa = {
  state: {
    // __wxConfig.envVersion !== "release"
    appId: appId,
    isNotReleaseEnv: process.env.VUE_APP_API_ENV !== "production",
    currentEnv: uni.getStorageSync("qaenv"),
  },
  mutations: {
    [types.SET_ENV_TAG](state, tag) {
      state.currentEnv = tag;
      uni.setStorageSync("qaenv", tag);
    },
  },
  actions: {
    changeEnvTag({ commit }, params) {
      commit(types.SET_ENV_TAG, params);
    },
  },
};
export default qa;
