import { sa, platformType } from "./mpConfig/types";
import config from "@/config";

export function saInit() {
  sa.setPara({
    name: "sa",
    server_url: config.shenceUrl,
    autoTrack: {
      appLaunch: true, // 默认为 true，false 则关闭 $MPLaunch 事件采集
      appShow: true, // 默认为 true，false 则关闭 $MPShow 事件采集
      appHide: true, // 默认为 true，false 则关闭 $MPHide 事件采集
      pageShow: true, // 默认为 true，false 则关闭 $MPViewScreen 事件采集
      pageShare: true, // 默认为 true，false 则关闭 $MPShare 事件采集
      mpClick: false, // 默认为 false，true 则开启 $MPClick 事件采集
      mpFavorite: true, // 默认为 true，false 则关闭 $MPAddFavorites 事件采集
    },
    source_channel: [
      "utm_source",
      "utm_content",
      "utm_campaign",
      "utm_medium",
      "utm_term",
      "utm_platform",
    ],
    show_log: false, // config.env !== "test"
  });
  sa.registerApp({
    platformType,
    tenant_id: uni.getStorageSync("tenantId") || "560761",
    parent_channelid: uni.getStorageSync("vccChannel") || "",
    son_channelid: uni.getStorageSync("sonVccChannel") || "",
  });
  sa.init();
}

export function saSetOpenid(openid) {
  sa.setOpenid(openid);
}

export function saTrackEvent(name, data, callback = () => {}) {
  // eslint-disable-next-line no-undef
  // #ifdef MP-BAIDU
  sa.track(name, data, callback);
  // #endif
  // #ifdef MP-WEIXIN|| mp-alipay
  getApp().sa.track(name, data, callback);
  // #endif
}

// 设置公共属性
export function setRegisterPage(registerPageObj) {
  sa.registerApp(registerPageObj);
}

export function saLogin(
  uuid = localStorage.getStorageSync("userAuthInfo").uuid
) {
  if (!uuid) return;
  sa.login(uuid);
}

export const saDeviceId = sa?.getAnonymousID();
// export const saDeviceId = sa.quick("getAnonymousID");
