import config from "@/config";
import { getVaildTmplIds } from "@/utils/subscribe";
const newTmplIds = [config.SUB_MSG_LIST.SPECIAL_PRODUCT];
const tmplIdsThree = [config.SUB_MSG_LIST.RECEIVE_COUPON, config.SUB_MSG_LIST.ACTIVITY_OPEN];
const tmplIds = [
  config.SUB_MSG_LIST.PAY_SUCCESS,
  config.SUB_MSG_LIST.RECEIPT_OPEN_SUCCESS,
  config.SUB_MSG_LIST.RECEIVE_COUPON
  // config.SUB_MSG_LIST.NEWPRODUCT_NOTICE
]; // 需要变更为消息通知
const OpVerSaConfig = {
  tmplIds: tmplIdsThree,
  saDoneData: ({ res, index }) => {
    const vaildTmplIds = getVaildTmplIds(res);
    return {
      trigger_node: `点击首页运营区竖向${index + 1}`,
      check_content: vaildTmplIds,
      buttons_name: "允许"
    };
  },
  saFailData: ({ index }) => ({
    trigger_node: `点击首页运营区竖向${index + 1}`,
    check_content: "优惠券领取提醒,活动开始提醒",
    buttons_name: "取消"
  })
};

export const SubscribeMessageConfig = {
  OperationPromotion_vertical: {
    indexArray: [OpVerSaConfig, OpVerSaConfig],
    saEvent: "MINI_MessageSubscriptionPopupBtnClick"
  },
  Banner: {
    indexArray: [
      {
        tmplIds: tmplIds,
        saDoneData: ({ res }) => {
          const vaildTmplIds = getVaildTmplIds(res);
          return {
            trigger_node: "首页banner-第一帧",
            check_content: vaildTmplIds,
            buttons_name: "允许"
          };
        },
        saFailData: {
          trigger_node: "首页banner-第一帧",
          check_content: "支付成功通知,发票开具成功提醒,优惠券领取提醒",
          buttons_name: "取消"
        }
      },
      {
        tmplIds: newTmplIds,
        saDoneData: {
          trigger_node: "首页banner-第二帧",
          check_content: "特价商品提醒",
          buttons_name: "允许"
        },
        saFailData: {
          trigger_node: "首页banner-第二帧",
          check_content: "特价商品提醒",
          buttons_name: "取消"
        }
      }
    ],
    saEvent: "MINI_MessageSubscriptionPopupBtnClick"
  },
  KingKongPosition: {
    saEvent: "MINI_MessageSubscriptionPopupBtnClick",
    indexArray: [
      {
        tmplIds: newTmplIds,
        saDoneData: {
          trigger_node: "点击首页金刚区第1个位置",
          check_content: "特价商品提醒",
          buttons_name: "允许"
        },
        saFailData: {
          trigger_node: "点击首页金刚区第1个位置",
          check_content: "特价商品提醒",
          buttons_name: "取消"
        }
      }
    ]
  }
};
