import request from "../utils/request";
import config from "@/config";
const { yxmGateway } = config;

// let kdspApi = "http://yapi.quantgroups.com/mock/351";

// 我的页面查询会员、优惠券信息
// 接口存在与app显示不一致情况，该接口提升version
const queryMemberAndCouponInfo = () => {
  // return request.get(
  //   "http://yapi.quantgroups.com/mock/351/api/kdsp/userBenefits/getCurrentLevelInfo"
  // );
  return request.get(
    `${yxmGateway}/api/kdsp/userBenefits/getCurrentLevelInfo`,
    {},
    {
      header: {
        version: "8.6.00"
      }
    }
  );
};

// 会员中心查询
const queryMemberCenterInfo = () => {
  return request.get(
    `${yxmGateway}/api/kdsp/userBenefits/center/getUserCenterInfo`,
    {},
    {
      header: {
        version: "8.6.00"
      }
    }
  );
};

// 获取用户会员权益明细
const queryMemberBenefitsDetail = () => {
  return request.get(
    `${yxmGateway}/api/kdsp/userBenefits/rewardDetail/getBenefitsDetail`,
    {},
    {
      header: {
        version: "8.6.00"
      }
    }
  );
};

// 获取用户会员权益值列表
const queryBenefitsDiscountDetail = data => {
  return request.get(
    `${yxmGateway}/api/kdsp/userBenefitsDiscountDetail/getBenefitsDiscountDetail`,
    data,
    {
      header: {
        version: "8.6.00"
      }
    }
  );
  // return request.get(
  //   `http://yapi.quantgroups.com/mock/351/api/kdsp/userBenefitsDiscountDetail/getBenefitsDiscountDetail`,
  //   data
  // );
};

// 获取成长值信息
const queryPointDetail = () => {
  return request.get(`${yxmGateway}/api/kdsp/userBenefits/getPointDetail`);
};

// 成长值（积分）列表
const getBenefitsDetail = () => {
  return request.get(`${yxmGateway}/api/kdsp/userBenefitsDetail/getBenefitsDetail`);
};

// 获取礼品卡消费记录
const getConsumptions = params => {
  return request.post(`${yxmGateway}/api/kdsp/card/io`, params);
};

// 领取优惠券
const pickupCoupon = params => {
  return request.post(`${yxmGateway}/api/kdsp/coupon/pickup-batch`, params, {
    reportDeviceId: true
  });
};

export {
  queryMemberAndCouponInfo,
  queryMemberBenefitsDetail,
  queryPointDetail,
  queryMemberCenterInfo,
  getConsumptions,
  pickupCoupon,
  queryBenefitsDiscountDetail,
  getBenefitsDetail
};
