export default {
  data() {
    const vm = this;
    return {
      rules: {
        invoiceTitle: [
          { validator: vm.validateTitle, message: '请输入发票抬头', trigger: 'onChange' }
        ],
        taxNumber: [
          { validator: vm.validateTaxId, message: '请输入正确内容', trigger: 'onChange' }
        ],
        email: [
          { validator: vm.validateEmail, message: '请输入发票收取邮箱', trigger: 'onChange' }
        ],
        mobile: [
          { validator: vm.validatePhoneNum, message: '请输入联系方式', trigger: 'onChange' }
        ],
        registAddress: [{ message: '请输入注册地址', trigger: 'onBlur' }],
        depositBank: [
          { validator: vm.validateBank, message: '只支持输入中文', trigger: 'onChange' }
        ]
      },
      titleFlag: false,
      taxIdFlag: false,
      emailFlag: false,
      phoneNumFlag: false
    };
  },

  methods: {
    stripscript(s) {
      const pattern = new RegExp(
        "[`~!@#$^&*%=|{}':;',\\[\\].<>/?~！@#￥……&*&mdash;—|{}【】‘；：”“'。，、？]"
      );
      let rs = '';
      for (let i = 0; i < s.length; i++) {
        rs = rs + s.substr(i, 1).replace(pattern, '');
      }
      this.formData.invoiceTitle = rs;
    },
    check(s) {
      const pattern = new RegExp('^([\u4E00-\uFA29]|[\uE7C7-\uE7F3]|[a-zA-Z_]|[0-9])');
      let res = true;
      for (let i = 0; i < s.length; i++) {
        if (!pattern.test(s[i])) {
          res = false;
          break;
        }
      }
      return res;
    },
    checkEnglish(s) {
      const pattern = new RegExp('^([a-zA-Z]|[@.]|[0-9])');
      let res = true;
      for (let i = 0; i < s.length; i++) {
        if (!pattern.test(s[i])) {
          res = false;
          break;
        }
      }
      return res;
    },
    validateBank(val) {
      const pattern = new RegExp('^([\u4E00-\uFA29]|[\uE7C7-\uE7F3])');
      let res = true;
      for (let i = 0; i < val.length; i++) {
        if (!pattern.test(val[i])) {
          res = false;
          break;
        }
      }
      return res;
    },
    validateTitle(val) {
      if (!val) {
        this.titleFlag = false;
        return false;
      } else {
        this.titleFlag = true;
        return true;
      }
    },
    validateTaxId(val) {
      if (!val) {
        this.taxIdFlag = false;
        return false;
      } else {
        if (!this.check(val)) {
          this.taxIdFlag = false;
          return false;
        } else {
          this.taxIdFlag = true;
          return true;
        }
      }
    },
    validateEmail(val) {
      if (!val) {
        this.emailFlag = false;
        return false;
      } else {
        if (!this.checkEnglish(val)) {
          this.emailFlag = false;
          return false;
        } else {
          this.emailFlag = true;
          return true;
        }
      }
    },
    validatePhoneNum(val) {
      if (!val) {
        this.phoneNumFlag = false;
        return false;
      } else {
        this.phoneNumFlag = true;
        return true;
      }
    }
  }
};
