import api from '@/api/receipts';
// import checkOpenMixin from './checkOpen.mixin';
import localStorageService from '@/service/localStorage.service';
export default {
  data() {
    return {};
  },
  // mixins: [checkOpenMixin],
  methods: {
    buttonClickEvent(event, item = {}) {
      this[event] && this[event](item);
    },
    async canReInvoice(invoiceSerialNum) {
      const [, error] = await api.canReInvoice(invoiceSerialNum);
      return error ? false : true;
    },

    // 重新开票
    async reOpen(item) {
      const invoiceSerialNum = item.invoiceSerialNum || this.$route.query.invoiceSerialNum || '';
      const next = await this.canReInvoice(invoiceSerialNum);
      if (next) {
        this.jumpAppUrl('/electronicReceipt/invoiceReceipt', { invoiceSerialNum });
      }
    },
    // 重新发送
    async reSend(item) {
      try {
        const invoiceSerialNum = item.invoiceSerialNum || this.$route.query.invoiceSerialNum || '';
        const [, error] = await api.resendInvoice(invoiceSerialNum);
        if (!error) {
          this.$toast('重新发送成功');
        }
      } catch {
        this.$toast('重新发送失败，请稍后再试');
      }
    },
    // 添加至微信卡包
    async addWeixinCard() {
      const invoiceSerialNum = this.$route.query.invoiceSerialNum;
      const [res, error] = await api.cardInvoiceAuthUrl(invoiceSerialNum);
      if (!error) {
        console.log(res);
        if (res?.authUrl) {
          localStorageService.set('invoiceRefresh', 1);
          window.location.href = res?.authUrl;
        }
      }
    },
    // 查看发票
    openPictureUrl(item) {
      const pictureUrl = item.pictureUrl || item.pdfUrl;
      const invoiceNo = item.invoiceNo || '';
      const invoiceCode = item.invoiceCode || '';
      this.jumpAppUrl('/electronicReceipt/invoiceShare', { pictureUrl, invoiceNo, invoiceCode });
    },
    // 分享发票
    shareInvoice(item) {
      const { pictureUrl, pdfUrl, invoiceNo, invoiceCode } = item;
      const linkPath = pictureUrl ? pictureUrl : pdfUrl;
      const describe = pictureUrl ? `${invoiceCode}-${invoiceNo}` : '美好生活更从容～';
      this.$bridge.run({
        event: 'showShareView',
        data: {
          platform: ['weChat', 'timeLine', 'QQ', 'QQZone', 'CopyLink'], //依次分别是微信、朋友圈、QQ好友、QQ空间、复制链接、生成海报
          shareDic: {
            title: '羊小咩电子发票',
            desc: describe,
            link: linkPath, // 页面地址
            imgUrl: 'https://img.lkbang.net/share-9a4526a20a7121e45687d1ad05a31b4b.png', // icon图片地址 https://img.lkbang.net/5453bf111b8ae36ee1c54dec2b9d7d93.png
            posterUrl: linkPath //海报图片地址
          }
        }
      });
    }
  }
};
