import config from '@/config';
import http from '@/service/httpDecorator';
import uiTrack from '@/service/sa.service';
const { yxmGwHost } = config;
const PAGE = 'home';
export const getBanner = () => {
  return http.get(`${yxmGwHost}/api/kdsp/appconfig/${PAGE}/topinfo`);
};
//获取动态内容【金刚区、运营专区等】【金刚区、运营专区-横向，运营专区-竖向， 通栏】
export const getContent = () => {
  //页面：home-精选，discovery-发现，profile-我的
  return http.get(`${yxmGwHost}/api/kdsp/appconfig/${PAGE}/content`);
};

export const getGoodsList = async data => {
  const scDeviceId = await uiTrack.run('saDeviceId');
  return http.get(`${yxmGwHost}/api/kdsp/recommend/goods-list`, {
    params: data,
    customHeader: {
      scDeviceId
    }
  });
};
export const apiCategoryGoodsList = async data => {
  const scDeviceId = await uiTrack.run('saDeviceId');
  return http.post(`${yxmGwHost}/api/kdsp/search/simple-result`, data, {
    customHeader: {
      scDeviceId,
      'x-user-terminal': 'H5'
    }
  });
};

export const homeSearch = async data => {
  const scDeviceId = await uiTrack.run('saDeviceId');
  // return http.post(`http://yapi.quantgroups.com/mock/305/vcc/xyqb/search/result`, data, {
  //   customHeader: {
  //     scDeviceId
  //   }
  // });
  return http.post(`${yxmGwHost}/api/kdsp/search/result`, data, {
    customHeader: {
      scDeviceId
    }
  });
};

export const getActivityInfo = data => {
  return http.post(`${yxmGwHost}/api/kdsp/search/result/fee/calc`, data, {
    needScDeviceId: true,
    hideLoading: true
  });
};

// 搜索--大家都在搜的关键词
export const getTerms = data => {
  return http.get(`${yxmGwHost}/vcc/app/mall/search/page`, data);
};
// 查询用户优惠券选择查询接口 http://yapi.quantgroups.com/project/645/interface/api/63019
export const getCouponChooseList = data => {
  return http.post(`${yxmGwHost}/api/kdsp/coupon/activity/choose-list/v3`, data);
};

export const getLoginPopup = page => {
  return http.get(`${yxmGwHost}/api/kdsp/app-config-push/${page}/popup`);
};
//.瓷片区一组四双列混排（新增,轮播）商品专题（新增,横板）商品专题（新增,竖板）
export const getLayout = async () => {
  const scDeviceId = await uiTrack.run('saDeviceId');
  return http.get(
    `${yxmGwHost}/api/kdsp/index/layout`,
    {
      customHeader: {
        scDeviceId
      }
    },
    {
      'x-user-terminal': 'H5'
    }
  );
};
//获取顶部信息
export const getTopTab = () => {
  return http.get(
    `${yxmGwHost}/api/kdsp/index/top-tab`,
    {},
    {
      'x-user-terminal': 'H5'
    }
  );
};
// 获取频道信息
export const apiCategoryInfo = async id => {
  const scDeviceId = await uiTrack.run('saDeviceId');
  return http.get(
    `${yxmGwHost}/api/kdsp/index/top-tab/category?id=${id}`,
    {
      customHeader: {
        scDeviceId
      }
    },
    {
      'x-user-terminal': 'H5'
    }
  );
};

// 不敢兴趣
// http://yapi.quantgroups.com/project/645/interface/api/62774
export const getReport = data => {
  return http.post(`${yxmGwHost}/api/kdsp/data/report`, data);
};
