import { getConfigType } from './utils';
import {
  QHYD,
  JSYD,
  YXM,
  CHANNEL_FL,
  CHANNEL_XC,
  CHANNEL_BAIDU,
  CHANNEL_TIANMEIDAI
} from './utils/config-type';
import Config from './config';
import QHYDConfig from './qhyd-config';
import JSYDConfig from './jsyd-config';
import YXMConfig from './yxm-config';
import XCConfig from './xc-config';
import FLWConfig from './flw-config';
import BAIDUConfig from './baidu-config';
import TMDConfig from './tmd-config';

const getChannelConfig = () => {
  switch (getConfigType('vccChannel', CHANNEL_FL)) {
    case CHANNEL_FL:
      return FLWConfig;
    case CHANNEL_XC:
      return XCConfig;
    case CHANNEL_BAIDU:
      return BAIDUConfig;
    case CHANNEL_TIANMEIDAI:
      return TMDConfig;
  }

  return YXMConfig;
};

export const classPublicConfig = () => {
  // console.log(getConfigType('tenantId', YXM),"getConfigType")
  switch (getConfigType('tenantId', YXM)) {
    case QHYD:
      return QHYDConfig;
    case JSYD:
      return JSYDConfig;
    case YXM:
      return getChannelConfig();
  }
  return Config;
};
export const getPublicConfig = () => {
  const publicConfig = classPublicConfig();
  return new publicConfig();
};
