export const currentDate = (year, month, day) => {
  return new Date(year, month, day);
};

export function getDayByOffset(date, offset) {
  date = new Date(date);
  date.setDate(date.getDate() + offset);
  return date;
}

export function getPrevDay(date) {
  return getDayByOffset(date, -1);
}

export function getNextDay(date) {
  return getDayByOffset(date, 1);
}

export const getMonth = time => {
  return new Date(time.replace(/-|\./g, '/')).getMonth() + 1;
};

export const getDotDate = time => {
  return +new Date(time.replace(/-|\./g, '/'));
};

export const getCurrentMonth = (year, month) => {
  return +new Date(year, month);
};

// 获取对应日期1号对应星期几
export const getFirstDayOrWeek = (year, month, day = 1) =>
  currentDate(year, month - 1, day).getDay();

// 获取对应日期当月所有天数队列
export const getDateByMonthOrDays = (year, month) => {
  const days = currentDate(year, month, 0).getDate();
  return new Array(days).fill(null).map((_, i) => i + 1);
};

export const filterSortList = result => {
  console.log(Object.keys(result));
  return Object.keys(result)
    .sort((a, b) => Date.parse(b) - Date.parse(a))
    .map(item => ({
      name: item,
      value: result[item]
    }));
  // console.log(arr);
  // // resultList
  // return [];
};
