import Clipboard from 'clipboard';
export default {
  methods: {
    setClipboardData(
      options = {
        data: '',
        success: () => {
          return;
        },
        fail: () => {
          return;
        }
      }
    ) {
      const fakeEl = document.createElement('button');
      const clipboard = new Clipboard(fakeEl, {
        text() {
          return options.data || '';
        },
        action() {
          return 'copy';
        },
        container: document.body
      });
      clipboard.on('success', e => {
        clipboard.destroy();
        if (options.success) {
          options.success(e);
        }
      });
      clipboard.on('error', e => {
        clipboard.destroy();
        if (options.fail) {
          options.fail(e);
        }
      });
      document.body.appendChild(fakeEl);
      fakeEl.click();
      document.body.removeChild(fakeEl);
    }
  }
};
