import Config from './config';

import path from 'path';
const resolve = dir => path.join(__dirname, dir);
const faviconPath = resolve('/public/logo.png');
export default class BAIDUConfig extends Config {
  constructor() {
    super();
    this.yxm = true;
    this.baidu = true;
    this.faviconPath = faviconPath;
    this.talosHost = 'https://talos.xyqb.com';
    this.kdspHost = 'https://kdsp-api.q-gp.com';
    this.userCardTop = '-25px';
    this.customerServiceName = '在线客服';
    this.registerRreaty = {
      url: 'https://page.q-gp.com/he-tong-yu-lan/?contractTemplateId=280',
      label: '用户注册协议'
    };
    this.privacyRreaty = {
      url: 'https://page.q-gp.com/he-tong-yu-lan/?contractTemplateId=8',
      label: '隐私政策'
    };
    this.quotaInfo = {
      title: '我的享花卡',
      leftText: '可用额度(元)',
      rightText: '待还款(元)'
    };
    this.payTip = '请选择现金券支付！';
  }
  signOutFn() {
    location.href = `/login?backUrl=${location.href}`;
  }
}
