import request from '@/service/httpDecorator';
import config from '@/config';
const { yxmGwHost } = config;
export default {
  getOrderList(params) {
    return request.get(`${yxmGwHost}/api/kdsp/order-inovice/order/list`, {
      params,
      hideLoading: true
    });
  },
  getReceiptList(params) {
    return request.get(
      `${yxmGwHost}/api/kdsp/order-inovice/invoice/list?pageNo=${params.pageNo}&pageSize=${params.pageSize}`
    );
  },
  addInvoice(data) {
    return request.post(`${yxmGwHost}/api/kdsp/order-inovice/add`, data);
  },
  // 重新开票
  reAddInvoice(data) {
    return request.post(`${yxmGwHost}/api/kdsp/order-inovice/reAdd`, data);
  },
  // 发票详情
  invoiceDetail(params) {
    return request.get(`${yxmGwHost}/api/kdsp/order-inovice/invoice/detail`, {
      params
    });
  },
  // 重新发送
  resendInvoice(serialNum) {
    return request.post(`${yxmGwHost}/api/kdsp/order-inovice/resend?invoiceSerialNum=${serialNum}`);
  },
  // 添加至微信卡包
  cardInvoiceAuthUrl(serialNum) {
    return request.get(
      `${yxmGwHost}/api/kdsp/order-inovice/card/invoice/auth-url?invoiceSerialNum=${serialNum}`
    );
  },

  canReInvoice(serialNum) {
    return request.post(`${yxmGwHost}/api/kdsp/order-inovice/canReInvoice`, {
      invoiceSerialNum: serialNum
    });
  },
  checkZero(params) {
    return request.post(`${yxmGwHost}/api/kdsp/order-inovice/canInvoice`, params, {
      hideToast: true,
      noAlert: true
    });
  },
  // 发票抬头列表查询
  userInoviceTitleList(params) {
    return request.get(`${yxmGwHost}/api/kdsp/userInoviceTitle/list`, {
      params
    });
  },
  // 发票抬头新增
  userInoviceTitleAdd(data) {
    return request.post(`${yxmGwHost}/api/kdsp/userInoviceTitle/add`, data);
  },
  // 发票抬头删除
  userInoviceTitleDisable(id) {
    return request.post(`${yxmGwHost}/api/kdsp/userInoviceTitle/disable`, { id });
  },
  // 发票抬头修改
  userInoviceTitleModify(data) {
    return request.post(`${yxmGwHost}/api/kdsp/userInoviceTitle/modify`, data);
  },
  // 诺诺前缀查询企业名称和税号
  userInovicePrefixQuery(params) {
    return request.get(`${yxmGwHost}/api/kdsp/order-inovice/invoice/prefixQuery`, {
      params
    });
  },
  // 源文件: @/views/electronicReceipt/invoiceHelp/bmall-ui-electronicReceipt-help.json
  userInoviceHelpQuery() {
    // activitystatic.xyqb.com
    return request.get(
      `https://img.lkbang.net/bmall-ui-electronicReceipt-help.json?t=${Date.now()}`
    );
  }
};
