import Vue from "vue";
import Vuex from "vuex";
import user from "./modules/user";
import { isXyqb } from "@/service/validation";
import localStorage from "@/service/localStorage";

Vue.use(Vuex);

export default new Vuex.Store({
  state: {
    activeIdx: 0,
    isLoading: false,
    isShowLogin: false,
    isPayWait: false,
    isShowPublicPopup: false,
    isShowOpenBrower: false,
    publicPupopData: {
      title: "",
      content: "",
      url: ""
    },
    showAuthXyqb: isXyqb ? localStorage.get("xyqbAuthState") || 1 : -1 // 1 已获取信息未授权，2 打开授权弹框， 3 拒绝授权，4 允许授权, -1 非信用钱包环境
  },
  mutations: {
    setActiveIdx(state, value) {
      state.activeIdx = value;
    },
    setIsLoading(state, value) {
      state.isLoading = value;
    },
    setIsShowLogin(state, value) {
      state.isShowLogin = value;
    },
    setIsPayWait(state, value) {
      state.isPayWait = value;
    },
    setIsShowOpenBrower(state, value) {
      state.isShowOpenBrower = value;
    },
    setAuthXyqb(state, value) {
      state.showAuthXyqb = value;
      localStorage.set("xyqbAuthState", value);
    },
    setPublicPopup(state, value) {
      if (value.content || value.url) {
        state.publicPupopData = value;
        state.isShowPublicPopup = true;
      } else {
        state.isShowPublicPopup = false;
      }
    }
  },
  actions: {
    setActiveIdx({ commit }, args) {
      commit("setActiveIdx", args);
    },
    setIsLoading({ commit }, args) {
      commit("setIsLoading", args);
    },
    setIsShowLogin({ commit }, args) {
      commit("setIsShowLogin", args);
    },
    setIsPayWait({ commit }, args) {
      commit("setIsPayWait", args);
    },
    setIsShowOpenBrower({ commit }, args) {
      commit("setIsShowOpenBrower", args);
    },
    setAuthXyqb({ commit }, args) {
      commit("setAuthXyqb", args);
    },
    setPublicPopup({ commit }, args) {
      commit("setPublicPopup", args);
    }
  },
  modules: {
    user
  }
});
