export default [
  {
    path: "/",
    name: "Default",
    redirect: "/home"
  },
  {
    path: "/home",
    name: "Home",
    component: () => import("../views/Home/index.vue"),
    meta: { title: "芒果保险" }
  },
  {
    path: "/home/smart-measure",
    name: "SmartMeasure",
    component: () => import("../views/Home/SmartMeasure/index.vue"),
    meta: { title: "智能风险评测" }
  },
  {
    path: "/home/smart-measure/report",
    name: "Report",
    component: () => import("../views/Home/SmartMeasure/Report/index.vue"),
    meta: { title: "智能风险评测" }
  },
  {
    path: "/home/activity",
    name: "Activity",
    component: () => import("../views/Home/Activity/index.vue"),
    meta: { title: "芒果保险" }
  },
  {
    path: "/goods",
    name: "Goods",
    component: () => import("../views/Goods/index.vue"),
    meta: { title: "产品" }
  },
  {
    path: "/goods/detail",
    name: "GoodsDetail",
    component: () => import("../views/Goods/Detail/index.vue"),
    meta: { title: "" }
  },
  {
    path: "/goods/plan",
    name: "GoodsPlan",
    component: () => import("../views/Goods/Plan/index.vue"),
    meta: { title: "保障详情" }
  },
  {
    path: "/goods/inform",
    name: "GoodsInform",
    component: () => import("../views/Goods/Inform/index.vue"),
    meta: { title: "健康告知" }
  },
  {
    path: "/consultant",
    name: "Consultant",
    component: () => import("../views/Consultant/index.vue"),
    meta: { title: "1对1保险顾问" }
  },
  {
    path: "/consultant/plan",
    name: "ConsultantPlan",
    component: () => import("../views/Consultant/Plan/index.vue"),
    meta: { title: "保险顾问" }
  },
  {
    path: "/user",
    name: "User",
    component: () => import("../views/User/index.vue"),
    meta: { title: "我的" }
  },
  {
    path: "/user/family",
    name: "Family",
    component: () => import("../views/User/Family/index.vue"),
    meta: { title: "添加家人" }
  },
  {
    path: "/user/family/detail/:id",
    name: "FamilyDetail",
    component: () => import("../views/User/Family/Detail/index.vue"),
    meta: { title: "修改信息" }
  },
  {
    path: "/user/apply-claims",
    name: "ApplyClaims",
    component: () => import("../views/User/ApplyClaims/index.vue"),
    meta: { title: "申请理赔" }
  },
  {
    path: "/user/help-center",
    name: "HelpCenter",
    component: () => import("../views/User/HelpCenter/index.vue"),
    meta: { title: "帮助中心" }
  },
  {
    path: "/user/help-center/answer/:type/:id",
    name: "Answer",
    component: () => import("../views/User/HelpCenter/Answer/index.vue"),
    meta: { title: "帮助中心" }
  },
  {
    path: "/user/help-center/subsection/:type",
    name: "Subsection",
    component: () => import("../views/User/HelpCenter/Subsection/index.vue"),
    meta: { title: "帮助中心" }
  },
  {
    path: "/policy",
    name: "Policy",
    component: () => import("../views/Policy/index.vue"),
    meta: { title: "我的保单" }
  },
  {
    path: "/policy/detail/:orderNo",
    name: "PolicyDetail",
    component: () => import("../views/Policy/Detail/index.vue"),
    meta: { title: "保单详情" }
  },
  {
    path: "/policy/virtual-detail",
    name: "PolicyVirtualDetail",
    component: () => import("../views/Policy/VirtualDetail/index.vue"),
    meta: { title: "芒果保险" }
  },
  {
    path: "/policy/success/:orderNo",
    name: "Sucess",
    component: () => import("../views/Policy/Success/index.vue"),
    meta: { title: "芒果保险" }
  },
  {
    path: "/policy/add",
    name: "AddPolicy",
    component: () => import("../views/Policy/Add/index.vue"),
    meta: { title: "填写保单" }
  },
  {
    path: "/policy/renewal/:orderNo/:policySecId",
    name: "Renewal",
    component: () => import("../views/Policy/Renewal/index.vue"),
    meta: { title: "次年自动续保" }
  },
  {
    path: "/policy/payment-record/:policySecId/:status/:isAClear",
    name: "Renewal",
    component: () => import("../views/Policy/PaymentRecord/index.vue"),
    meta: { title: "缴费记录" }
  },
  {
    path: "/introduction",
    name: "Introduction",
    component: () => import("../views/Introduction/index.vue"),
    meta: { title: "了解芒果保险" }
  },
  {
    path: "/payWaiting",
    name: "PayWaiting",
    component: () => import("../views/Policy/PayWaiting/index.vue"),
    meta: { title: "支付中" }
  },
  {
    path: "*",
    redirect: "/goods"
  }
];
