/* eslint-disable */
/*
 * //TODO 后期可以做成json文件，以减小包体积
 * @Description:华太30万轻重疾险
 * @Date: 2020-07-27 15:46:37
 * @LastEditors: gzw
 * @LastEditTime: 2020-08-21 20:00:22
 */

import goodsBg from "@/assets/images/goods/detail/zhongjixian/bg.png";
import intro01 from "@/assets/images/goods/detail/zhongjixian/intro-01.png";
import intro02 from "@/assets/images/goods/detail/zhongjixian/intro-02.png";
import intro03 from "@/assets/images/goods/detail/zhongjixian/intro-03.png";
import intro04 from "@/assets/images/goods/detail/zhongjixian/intro-04.png";

export default {
  type: "cii",
  productNo: "HTDQZJX001",
  headerInfo: {
    bgSrc: goodsBg,
    type: "huatai",
    company: "华泰财险",
    title: "30万重疾轻症保障",
    sub: "100种重症+40种轻症确诊即赔",
    price: [3, "元", "首月"],
    subPrice: [5.6, "元/月起", "次月", "（共11期）"],
    insuredNum: 0,
    stamp: true
  },
  introImg: [intro01, intro02, intro03, intro04],
  companyInfo: [
    { content: "承保公司：华泰财产保险有限公司", offset: false },
    { content: "经营范围：短期健康保险和意外伤害保险", offset: false },
    { content: "备案名称：华泰财险重大疾病保险条款", offset: false },
    { content: "华泰财险附加重大疾病轻症综合保险条款；", offset: true },
    { content: "华泰财险附加保险费分期支付条款", offset: true },
    { content: "备案编号：C00015431912018061501152；", offset: false },
    { content: "C00015432622017111500872；", offset: true },
    { content: "C00015431922018061503991", offset: true }
  ],
  navBarOptions: [
    { label: "我要投保", value: "insure" },
    { label: "产品特色", value: "intro" },
    { label: "理赔说明", value: "process" }
  ],
  autoCellInfo: [
    { title: "【省心】自动续保，不用担心续保不及时导致保障中断", value: "" },
    { title: "【放心】开通自动续保后，可随时取消", value: "" },
    { title: "【安心】续保保费按续保时对应的保费自动扣款", value: "" },
    {
      title: {
        needSlot: true,
        tpl: " 阅读并同意<a href='javascript:;'>《自动续保服务协议》</a>"
      },
      value: ""
    }
  ],
  planCellInfo: {
    "300000": [
      { title: "100种重大疾病医疗保险金", value: "30万" },
      { title: "40种轻症保险金", value: "6万" },
      { title: "投保年龄", value: "30天~50周岁" },
      { title: "保险期限", value: "1年" }
    ],
    "200000": [
      { title: "100种重大疾病医疗保险金", value: "20万" },
      { title: "40种轻症保险金", value: "4万" },
      { title: "投保年龄", value: "30天~60周岁" },
      { title: "保险期限", value: "1年" }
    ],
    "100000": [
      { title: "100种重大疾病医疗保险金", value: "10万" },
      { title: "40种轻症保险金", value: "2万" },
      { title: "投保年龄", value: "30天~60周岁" },
      { title: "保险期限", value: "1年" }
    ]
  },
  securityContent: {
    "300000": [
      { id: 1, title: "100种重大疾病医疗保险金", value: "30万" },
      { id: 2, title: "40种轻症保险金", value: "6万" },
      { id: 3, title: "生效日期", value: "" },
      { id: 4, title: "终止日期", value: "" }
    ],
    "200000": [
      { id: 1, title: "100种重大疾病医疗保险金", value: "20万" },
      { id: 2, title: "40种轻症保险金", value: "4万" },
      { id: 3, title: "生效日期", value: "" },
      { id: 4, title: "终止日期", value: "" }
    ],
    "100000": [
      { id: 1, title: "100种重大疾病医疗保险金", value: "10万" },
      { id: 2, title: "40种轻症保险金", value: "2万" },
      { id: 3, title: "生效日期", value: "" },
      { id: 4, title: "终止日期", value: "" }
    ]
  },
  planTipOptions: ["轻症赔付后，重疾保障继续有效", "可逐年续保至99岁"],
  planOptions: [
    { label: "30万", value: "300000" },
    { label: "20万", value: "200000" },
    { label: "10万", value: "100000" }
  ],
  insuredOptions: [
    { label: "本人", value: "1" },
    { label: "父母", value: "2" },
    { label: "配偶", value: "3" },
    { label: "子女", value: "4" }
  ],
  paywayOptions: [
    { label: "月缴<small style='color: #999;font-size: 11px'>（12期）</small>", value: "1" },
    { label: "一次交清", value: "2" }
  ],
  noticeCellInfo: {
    "300000": [
      { title: "投保年龄", value: `30天~50周岁` },
      { title: "保障期限", value: "1年（可续保至99周岁）" },
      { title: "等待期", value: "90天" },
      {
        title: "保费",
        value: {
          needSlot: true,
          tpl: "保费与保额、被保人年龄有关<br />首月3元，次月5.6元/月起",
          longTxt: true
        }
      }
    ],
    "200000": [
      { title: "投保年龄", value: `30天~60周岁` },
      { title: "保障期限", value: "1年（可续保至99周岁）" },
      { title: "等待期", value: "90天" },
      {
        title: "保费",
        value: {
          needSlot: true,
          tpl: "保费与保额、被保人年龄有关<br />首月3元，次月5.6元/月起",
          longTxt: true
        }
      }
    ],
    "100000": [
      { title: "投保年龄", value: `30天~60周岁` },
      { title: "保障期限", value: "1年（可续保至99周岁）" },
      { title: "等待期", value: "90天" },
      {
        title: "保费",
        value: {
          needSlot: true,
          tpl: "保费与保额、被保人年龄有关<br />首月3元，次月5.6元/月起",
          longTxt: true
        }
      }
    ]
  },
  popupArray: [
    {
      title: "保险条款",
      url: "https://mangguo-contract.qthbx.com/huatai-bao-xian-tiao-kuan-v1/"
    },
    {
      title: "健康告知",
      url: "https://mangguo-contract.qthbx.com/huatai-jian-kang-gao-zhi-v1/"
    },
    {
      title: "投保须知及声明",
      url: "https://mangguo-contract.qthbx.com/huatai-toubaoxuzhi-v1/"
    },
    {
      title: "平台服务协议",
      url: "https://mangguo-contract.qthbx.com/fu-wu-xie-yi-v1/"
    },
    { title: "保险计划" },
    { title: "理赔信息" },
    { title: "完整费率" },
    {
      title: "自动续保服务协议",
      url: "https://mangguo-contract.qthbx.com/zi-dong-xu-bao-fu-wu-xie-yi-v1/"
    }
  ],
  protocolData: [
    { title: "保险条款", id: 0 },
    { title: "健康告知", id: 1 },
    { title: "投保须知及声明", id: 2 },
    { title: "平台服务协议", id: 3 }
  ],
  caseInfo: {
    name: "吴先生",
    info: "46岁 北京 有社保",
    list: [
      {
        title: "投保",
        event: "2018年6月29日，吴先生为自己投保了一份万家保·重疾轻症险，保额20万，并续保。"
      },
      {
        title: "投保",
        event: "2019年9月16日，吴先生意外烫伤双下肢皮肤，达到浅Ⅲ°烧伤，烧伤面积达20"
      },
      {
        title: "轻症理赔",
        event: "2019年9月17日，吴先生后向我司报案，经核实符合该保险中轻症“特定面积Ⅲ度烧伤”的诊断赔付标准，给予4万保险金赔付。"
      },
      {
        title: "重疾理赔",
        event: "2020年1月3日，吴先生突发胸痛咯血，后诊断为右肺非小细胞性肺癌，经我司核实后确认为保险责任，一次性给予20万元的重大疾病保险金。"
      }
    ]
  },
  qaInfo: [
    {
      q: "这个产品的等待期是多久？",
      a: "本产品的等待期为90天,意外及续保无等待期。"
    },
    {
      q: "如果同时购买了其他重疾险，可以赔付2次吗？",
      a: "本保险产品为一次性给付型产品，如果您购买的重疾险为一次性给付型或报销型产品，可以和本保险同时申请理赔，获得两份赔偿。如果出险，请拨打华泰财险24小时客服电话4006095509。"
    },
    {
      q: "这款产品提供了哪些保障？",
      a: "本产品对人一生中可能罹患的99%以上的100种重大疾病提供保障，同时还有40种轻症保障也包含在内。在保险期间内，被保险人因意外伤害或在等待期后因疾病初次确诊罹患本产品定义的重大疾病或轻症的，即可获得一笔保险补偿。"
    },
    {
      q: "被保险人有哪些限制？",
      a: "可以为出生满30天-60周岁（含）身体健康，且符合健康告知提及状况的本人、配偶、子女或父母投保。"
    },
    {
      q: "理赔后是否可以续保？需要重新完成健康告知吗？",
      a: "无理赔或者已理赔过轻症的第二年可以续保；已理赔过重症的第二年不可以续保；续保无需重新填写健康告知。"
    },
    {
      q: "如何在华泰官网进行保单验真？",
      a: "请登录投保成功短信中提示的华泰官网查询网http://agt.ehuatai.com/nonautoquery/。填写登录信息时，类别选择“家庭财产、意外伤害保险”，保单号在投保成功的短信中，密码填写被保险人身份证号，即可登录查询保单承保信息。"
    }
  ],
  processDetail: [
    {
      title: "电话报案",
      desc: "请拨打华泰财险400-609-5509进行报案。华泰财险会有理赔专员1对1指导理赔事宜。 "
    },
    {
      title: "准备材料",
      desc: `1、索赔申请书；<br />
      2、保险单或保险凭证复印件；（电子保单，不需要纸质）;<br />
      3、被保险人身份证正反面复印件；<br />
      4、有关部门出具的事故经过说明，如涉及交通事故，需提供交通事故责任认定书、被保险人驾驶证正副页复印件、机动车行驶证正副页复印件；涉及安全生产事故的，提供安全监管部门出具的调查报告；涉及特种作业的，提供被保险人特种作业操作证；<br />
      5、医疗发票、医疗明细清单、门急诊病历、住院病历、病历检查报告等原件（若社保先报销则提供医疗费用分割单）；<br />
      6、其他与确认保险事故性质、原因、损失程度等有关的证明或材料。<br />
      `
    },
    {
      title: "理赔付款",
      desc: `1、转账方式直接支付给被保险人；<br />
      2、若被保险人身故的，则转账支付给指定受益人或法定受益人。`
    }
  ],
  rateInfo: [
    {
      title: "按月交费",
      th: ["投保年龄", "男", "女"],
      age: ["0-1", "2-17", "18-20", "21-25", "26-30", "31-35", "36-40", "41-45", "46-50", "51-55", "56-60"],
      list: [
        [
          [30.7, 19.5, 23.1, 25.8, 34.3, 51.3, 86.8, 146.4, 252.3, "", ""],
          [26.2, 17.2, 21.3, 29.3, 46.4, 75.6, 113.7, 166.6, 229.0, "", ""]
        ],
        [
          [20.4, 12.9, 15.3, 17.1, 22.8, 34.1, 57.8, 97.5, 168.1, 285.1, 443.3],
          [17.4, 11.4, 14.1, 19.5, 30.8, 50.3, 75.7, 111, 152.6, 210.9, 303.6]
        ],
        [
          [10, 6.3, 7.5, 8.4, 11.2, 16.9, 28.7, 48.6, 83.9, 142.4, 221.5],
          [8.6, 5.6, 6.9, 9.6, 15.3, 25, 37.7, 55.4, 76.2, 105.3, 151.7]
        ]
      ]
    },
    {
      title: "一次交清",
      th: ["投保年龄", "男", "女"],
      age: ["0-1", "2-17", "18-20", "21-25", "26-30", "31-35", "36-40", "41-45", "46-50", "51-55", "56-60", "61-65", "66-70", "71-75", "76-80", "81-85", "86-90", "91-95", "96-99"],
      list: [
        [
          [334, 213, 252, 281, 373, 556, 939, 1582, 2724, 4616, 7176, 10505, 15247, 22582, 34031, 49350, 68806, 91974, 120048],
          [285, 189, 232, 319, 503, 818, 1229, 1800, 2473, 3416, 4916, 7650, 13398, 21368, 32216, 46892, 64195, 83506, 105165]
        ],
        [
          [223, 142, 168, 187, 248, 371, 626, 1055, 1816, 3077, 4784, 7003, 10165, 15055, 22687, 32900, 45871, 61316, 80032],
          [190, 126, 155, 213, 335, 545, 819, 1200, 1648, 2277, 3277, 5100, 8932, 14245, 21477, 31261, 42797, 55671, 70110]
        ],
        [
          [111, 71, 84, 94, 124, 185, 313, 527, 908, 1539, 2392, 3502, 5082, 7527, 11344, 16450, 22935, 30658, 40016],
          [95, 63, 77, 106, 168, 273, 410, 600, 824, 1139, 1639, 2550, 4466, 7123, 10739, 15631, 21398, 27835, 35055]
        ]
      ]
    }
  ],
  planInfo: [
    {
      title: "100种重大疾病保险金",
      desc:
        "<p>重大疾病包括恶性肿瘤、急性心肌梗塞、终末期肾病（或称慢性肾功能衰竭尿毒症期）等100种。在等待期（90天，意外伤害事故无等待期）后初次发生并经医院专科医生确诊罹患本合同约定的一种或多种重大疾病，保险人按照保险单中约定的重大疾病保险金额给付重大疾病保险金，同时在本保险合同项下对该被保险人的保险责任终止。</p>",
      options: [
        { title: "查看100种重大疾病", type: "popup", path: "https://mangguo-contract.qthbx.com/hua-tai-100chong-zhong-ji-v1/" }
      ]
    },
    {
      title: "40种轻症疾病保险金",
      desc:
        "<p>轻症疾病包括冠状动脉介入手术、非危及生命的（极早期的）恶性病变、轻度中风后遗症等40种。在等待期（90天，意外伤害事故无等待期）后初次发生并经医院专科医生确诊罹患本合同约定的一种或多种轻症。保险人按照保险合同中约定的轻症保险金额给付轻症保险金，同时轻症责任终止。轻症保险金仅针对本保险合同约定的轻症进行给付，轻症疾病必须在生前诊断，对于任何身故后的尸检诊断不给付轻症疾病保险金。对于已经符合重大疾病保险金给付条件的，仅给付重大疾病保险金，不再给付轻症保险金。</p>",
      options: [
        { title: "查看40种轻症疾病", type: "popup", path: "https://mangguo-contract.qthbx.com/hua-tai-100chong-qing-zheng-v1/" }
      ]
    },
    {
      title: "保额说明",
      desc: `
          <p><strong>重疾30万保额：</strong></p>
          <p>30天~50周岁可投保，可逐年续保至99周岁。</p>
          <p><strong>重疾20万保额：</strong></p>
          <p>30天~60周岁可投保，可逐年续保至99周岁。</p>
          <p><strong>重疾10万保额：</strong></p>
          <p>
          30天~60周岁可投保，可逐年续保至99周岁。</p>
      `
    }
  ]
};
