/*
 * @Description: PopupPicker mixin
 * @Date: 2020-07-28 19:46:31
 * @LastEditors: gzw
 * @LastEditTime: 2020-07-28 20:33:52
 */

// TODO 默认值需要处理
const VALUE_CHANGE_EVENT = "input";
export default {
  name: "PopupPicker",
  props: {
    value: null,
    placeholder: {
      type: String,
      default: "请选择"
    },
    pickerData: {
      type: Array,
      default() {
        return [];
      }
    }
  },
  data() {
    return {
      show: false,
      pickerVal: "",
      refreshed: false,
      refName: "picker",
      pickerValShow: ""
    };
  },
  watch: {
    show(val) {
      if (val && !this.refreshed) {
        this.refreshed = true;
        this.$refs[this.refName].refreshColumns();
      }
    }
    // value: {
    //   immediate: true,
    //   handler(val) {
    //     this.pickerValShow = val[0];
    //     this.pickerVal = val[1];
    //   }
    // }
  },
  methods: {
    onCancel() {
      this.show = false;
    },
    onConfirm(picker, res) {
      this.handleResult(res);
      this.$emit(VALUE_CHANGE_EVENT, String(this.pickerVal));
      this.onCancel();
    }
  }
};
