import Vue from "vue";
import Vuex from "vuex";
import user from "./modules/user";

Vue.use(Vuex);

export default new Vuex.Store({
  state: {
    activeIdx: 0,
    isLoading: false,
    isShowLogin: false,
    showAuthXyqb: "init" // init 已获取信息未授权，pending 授权弹框
  },
  mutations: {
    setActiveIdx(state, value) {
      state.activeIdx = value;
    },
    setIsLoading(state, value) {
      state.isLoading = value;
    },
    setIsShowLogin(state, value) {
      state.isShowLogin = value;
    },
    authXyqb(state, value) {
      state.showAuthXyqb = value;
    }
  },
  actions: {
    setActiveIdx({ commit }, args) {
      commit("setActiveIdx", args);
    },
    setIsLoading({ commit }, args) {
      commit("setIsLoading", args);
    },
    setIsShowLogin({ commit }, args) {
      commit("setIsShowLogin", args);
    },
    setsuthXyqb({ commit }, args) {
      commit("setShowAuthXyqb", args);
    }
  },
  modules: {
    user
  }
});
