import localStorage from "@/service/localStorage";

export function routerStorage(toPath, fromPath) {
  let storage = localStorage.get("history") || { isBack: false, paths: [], fromPath: "" };
  if (storage.paths.includes(toPath)) {
    const toPathIndex = storage.paths.indexOf(toPath);
    storage = { ...storage, isBack: true, fromPath };
    storage.paths.splice(toPathIndex + 1);
  } else {
    storage = { ...storage, isBack: false, fromPath };
    storage.paths.push(toPath);
  }
  localStorage.set("history", storage);
}

export function isBack(excludeFromPath = "") {
  let storage = localStorage.get("history") || { isBack: false, paths: [], fromPath: "" };
  if (storage.isBack && excludeFromPath !== storage.fromPath) {
    return true;
  }
  return false;
}
