import Vue from "vue";
import VueRouter from "vue-router";

Vue.use(VueRouter);

const routes = [
  {
    path: "/",
    name: "Home",
    redirect: "/goods"
  },
  {
    path: "/goods",
    name: "Goods",
    component: () => import("../views/Goods/index.vue")
  },
  {
    path: "/goods/detail",
    name: "GoodsDetail",
    component: () => import("../views/Goods/Detail/index.vue")
  },
  {
    path: "/goods/plan",
    name: "GoodsPlan",
    component: () => import("../views/Goods/Plan/index.vue")
  },
  {
    path: "/goods/inform",
    name: "GoodsInform",
    component: () => import("../views/Goods/Inform/index.vue")
  },
  {
    path: "/user",
    name: "User",
    component: () => import("../views/User/index.vue")
  },
  {
    path: "/policy",
    name: "Policy",
    component: () => import("../views/Policy/index.vue")
  },
  {
    path: "/policy/detail",
    name: "Detail",
    component: () => import("../views/Policy/Detail/index.vue")
  },
  {
    path: "/payment-record",
    name: "PaymentRecord",
    component: () => import("../views/PaymentRecord/index.vue")
  },
  {
    path: "/introduction",
    name: "Introduction",
    component: () => import("../views/Introduction/index.vue")
  },
  {
    path: "*",
    redirect: "/goods"
  }
];

const originalPush = VueRouter.prototype.push;

VueRouter.prototype.push = function push(location) {
  return originalPush.call(this, location).catch(err => err);
};

const router = new VueRouter({
  mode: "history",
  base: process.env.BASE_URL,
  routes,
  scrollBehavior() {
    return { x: 0, y: 0 };
  }
});

export default router;
