import Vue from "vue";
import VueRouter from "vue-router";
import Home from "../views/Home.vue";

Vue.use(VueRouter);

const routes = [
  {
    path: "/",
    name: "Home",
    redirect: "/goods"
  },
  {
    path: "/about",
    name: "About",
    // route level code-splitting
    // this generates a separate chunk (about.[hash].js) for this route
    // which is lazy-loaded when the route is visited.
    component: () => import(/* webpackChunkName: "about" */ "../views/About.vue")
  },
  {
    path: "/goods",
    name: "Goods",
    component: () => import(/* webpackChunkName: "goods" */ "../views/Goods/index.vue")
  },
  {
    path: "/goods/detail",
    name: "GoodsDetail",
    component: () => import(/* webpackChunkName: "goodsDetail" */ "../views/Goods/detail.vue")
  },
  {
    path: "/goods/plan",
    name: "GoodsPlan",
    component: () => import(/* webpackChunkName: "GoodsPlan" */ "../views/Goods/plan.vue")
  },
  {
    path: "/goods/inform",
    name: "GoodsInform",
    component: () => import(/* webpackChunkName: "GoodsInform" */ "../views/Goods/inform.vue")
  },
  {
    path: "/user",
    name: "User",
    component: () => import("../views/User/index.vue")
  }
];

const router = new VueRouter({
  mode: "history",
  base: process.env.BASE_URL,
  routes
});

export default router;
