/* eslint-disable */
/*
 * //TODO 后期可以做成json文件，以减小包体积
 * @Description: 华贵大麦2020定期寿险
 * @Date: 2020-07-27 15:46:37
 * @LastEditors: gzw
 * @LastEditTime: 2020-08-24 18:55:19
 */

import goodsBg from "@/assets/images/goods/detail/shouxian/bg.png";
import intro01 from "@/assets/images/goods/detail/shouxian/intro-01.png";
import intro02 from "@/assets/images/goods/detail/shouxian/intro-02.png";
import intro03 from "@/assets/images/goods/detail/shouxian/intro-03.png";

export default {
  type: "li",
  productNo: "HGSX001",
  headerInfo: {
    bgSrc: goodsBg,
    type: "huagui",
    company: "",
    title: "大麦2020定期寿险",
    price: [155, "元/年起"],
    subPrice: [155, "元/年", "剩余", "(共9年)"],
    insuredNum: 0,
    stamp: false
  },
  introImg: [intro01, intro02, intro03],
  companyInfo: [
    { content: "承保公司：华贵人寿保险股份有限公司", offset: false },
    { content: "经营范围：定期人寿保险", offset: false },
    { content: "备案编号：华贵保险[2019]207号；", offset: false }
  ],
  navBarOptions: [
    { label: "产品介绍", value: "intro" },
    { label: "理赔流程", value: "process" },
    { label: "投保须知", value: "notice" },
    { label: "常见问题", value: "qa" }
  ],
  autoCellInfo: [
    { title: "【省心】自动续保，不用担心续保不及时导致保障中断", value: "" },
    { title: "【放心】开通自动续保后，可随时取消", value: "" },
    { title: "【安心】自动续保按费率可自动扣费", value: "" },
    {
      title: {
        needSlot: true,
        tpl: " 阅读并同意<a href='javascript:;'>《自动续保服务协议》</a>"
      },
      value: ""
    }
  ],
  planCellInfo: [
    { title: "身故保险金", value: "100%基础保额（最高350万）" },
    { title: "全残保险金", value: "100%基础保额（最高350万）" },
    { title: "投保年龄", value: "18~60周岁" },
    { title: "保障期限", value: "保10年/20年/30年" },
    { title: " ", value: "保至60岁/65岁/70岁" }
  ],
  bankInfo: [
      {title: "工商银行", value: "0101"},
      {title: "农业银行", value: "0102"},
      {title: "中国银行", value: "0103"},
      {title: "建设银行", value: "0104"},
      {title: "招商银行", value: "0115"},
      {title: "贵州银行", value: "0105"},
      {title: "兴业银行", value: "0116"},
      {title: "民生银行", value: "0112"},
      {title: "邮政储蓄", value: "0128"}
  ],
  securityContent: [
    {id: 1, title: "身故保险金", value: ""},
    {id: 2, title: "意外伤残", value: ""},
    {id: 3, title: "保障期限", value: ""},
    {id: 4, title: "生效日期", value: ""},
    {id: 5, title: "受益人", value: "法定"},
    {id: 6, title: "交费年限", value: ""},
    {id: 7, title: "交费方式", value: ""},
  ],
  planTipOptions: ["最高350万", "高风险职业可保", "免体检"],
  noticeCellInfo: [
    { title: "投保年龄", value: `18~60周岁` },
    { title: "保障期限", value: "保10年/20年/30年/保至60岁/65岁/70岁" },
    { title: "交费期", value: "交5年/交10年/交20年/交30年/一次性交清" },
    { title: "等待期", value: "90天(因意外导致的身故或全残无等待期)" },
    { title: "犹豫期", value: "20天(犹豫期内退保,原额退还保费)" }
  ],
  socialSecOptions: [
    { label: "有社保", value: "1" },
    { label: "无社保", value: "0" }
  ],
  insuredOptions: [
    { label: "本人", value: "1" },
    { label: "父母", value: "2" },
    { label: "配偶", value: "3" },
    { label: "子女", value: "4" }
  ],
  medicalOptions: [
    { label: "有<small style='color: #999;font-size: 11px'>（含新农合）</small>", value: "1" },
    { label: "无", value: "0" }
  ],
  paywayOptions: [
    { label: "年缴", value: "1" }
  ],
  sexOptions: [
    { label: "男", value: "1" },
    { label: "女", value: "0" }
  ],
  idCardInvaildOptions: [
    { label: "非长期", value: "1" },
    { label: "长期", value: "2" }
  ],
  insuredAmountOptions: [
    { label: "30万", value: "300000" },
    { label: "50万", value: "500000" },
    { label: "80万", value: "800000" },
    { label: "100万", value: "1000000" },
    { label: "150万", value: "1500000" },
    { label: "200万", value: "2000000" },
    { label: "250万", value: "2500000" },
    { label: "300万", value: "3000000" },
    { label: "350万", value: "3500000" }
  ],
  termOptions: [
    { label: "10年", value: "1" },
    { label: "20年", value: "2" },
    { label: "30年", value: "3" },
    { label: "保至60周岁", value: "4" },
    { label: "保至65周岁", value: "5" },
    { label: "保至70周岁", value: "6" }
  ],
  benefitOptions: [
    { label: "交5年", value: "1" },
    { label: "交10年", value: "2" },
    { label: "交20年", value: "3" },
    { label: "交30年", value: "4" }
    // { label: "一次付清", value: "5" }
  ],
  popupArray: [
    {
      title: "保险条款",
      url: "http://mangguo-contract.qthbx.com/hua-gui-bao-xian-tiao-kuan-v1/"
    },
    {
      title: "健康告知",
      url: "http://mangguo-contract.qthbx.com/hua-gui-jian-kang-gao-zhi-v1/"
    },
    {
      title: "投保须知及声明",
      url: "http://mangguo-contract.qthbx.com/huagui-tou-bao-xu-zhi-v1/"
    },
    {
      title: "平台服务协议",
      url: "http://mangguo-contract.qthbx.com/fu-wu-xie-yi-v1/"
    },
    { title: "保险计划" },
    { title: "理赔信息" },
    { title: "算一算保费" },
    {
      title: "自动续保服务协议",
      url: "http://mangguo-contract.qthbx.com/zi-dong-xu-bao-fu-wu-xie-yi-v1/"
    },
    {
      title: "人身保险投保提示书",
      url: "http://mangguo-contract.qthbx.com/hua-gui-ren-shen-bao-xian-tou-bao-ti-shi-shu-v1/"
    },
    {
      title: "税收居民身份声明",
      url: "http://mangguo-contract.qthbx.com/hua-gui-shui-shou-ju-min-shen-fen-sheng-ming-v1/"
    },
    {
      title: "风控查询授权说明书",
      url: "	http://mangguo-contract.qthbx.com/hua-gui-feng-kong-cha-xun-shou-quan-shuo-ming-shu-v1/"
    },
    {
      title: "转账授权书",
      url: "http://mangguo-contract.qthbx.com/hua-gui-zhuan-zhang-shou-quan-shu-v1/"
    }
  ],
  protocolData: [
    { title: "保险条款", id: 0 },
    { title: "投保须知与声明", id: 2 },
    { title: "服务协议", id: 3 },
    { title: "转账授权书", id: 1 },
    { title: "人身保险投保提示书", id: 8 },
    { title: "税收居民身份证明", id: 3 },
    { title: "风控查询授权书", id: 3 }
  ],
  caseInfo: {
    name: "张先生",
    info: "33岁 北京",
    list: [
      {
        title: "投保",
        event: "张先生全家生活在北京，有一个可爱的女儿，考虑到家里的房贷、孩子教育，张先生为自己购买了华贵大麦2020定期寿险，保额100万，保障至70周岁，缴费期限20年。"
      },
      {
        title: "报案",
        event: "投保后第5年，张先生不幸身故，家人向保险公司报案。"
      },
      {
        title: "理赔",
        event: "张先生在投保时指定了受益人为张先生的太太和女儿，张太太及其女儿一次性获得100万赔偿金。"
      }
    ]
  },
  qaInfo: [
    {
      q: "这个产品的等待期是多久？",
      a: "本产品的等待期为90天,意外及续保无等待期。"
    },
    {
      q: "如果同时购买了其他重疾险，可以赔付2次吗？",
      a: "本保险产品为一次性给付型产品，如果您购买的重疾险为一次性给付型或报销型产品，可以和本保险同时申请理赔，获得两份赔偿。如果出险，请拨打华泰财险24小时客服电话4006095509。"
    },
    {
      q: "这款产品提供了哪些保障？",
      a: "本产品对人一生中可能罹患的99%以上的100种重大疾病提供保障，同时还有40种轻症保障也包含在内。在保险期间内，被保险人因意外伤害或在等待期后因疾病初次确诊罹患本产品定义的重大疾病或轻症的，即可获得一笔保险补偿。"
    },
    {
      q: "被保险人有哪些限制？",
      a: "可以为出生满30天-60周岁（含）身体健康，且符合健康告知提及状况的本人、配偶、子女或父母投保。"
    },
    {
      q: "理赔后是否可以续保？需要重新完成健康告知吗？",
      a: "无理赔或者已理赔过轻症的第二年可以续保；已理赔过重症的第二年不可以续保；续保无需重新填写健康告知。"
    },
    {
      q: "如何在华泰官网进行保单验真？",
      a: "请登录投保成功短信中提示的华泰官网查询网http://agt.ehuatai.com/nonautoquery/。填写登录信息时，类别选择“家庭财产、意外伤害保险”，保单号在投保成功的短信中，密码填写被保险人身份证号，即可登录查询保单承保信息。"
    }
  ],
  processDetail: [
    {
      title: "报案",
      desc: "通过华贵保险的官方网站、微信公众号，或拨打客服电话400-6841-888进行报案。"
    },
    {
      title: "提交资料",
      desc: `根据理赔专员的指导，准备理赔材料，并邮寄至指定地点进行审，或由保险公司指派人员上门收取。`
    },
    {
      title: "审核",
      desc: `保险公司收到材料后，对案件进行立案和审批。`
    },
    {
      title: "理赔付款",
      desc: `保险公司结案后，转账付款完成理赔。`
    }
  ],
  planInfo: [
    {
      title: "身故保险金（100%基本保额）",
      desc:
        "被保险人因意外原因或于本合同生效(或合同效力恢复)之日起90日后因非意外导致身故或身体全残，保险公司根据保险条款给付身故或全残保险金，本合同终止。被保险人于本合同生效(或合同效力恢复)之日起90日内因非意外导致身故或身体全残，保险公司退还实际已交保费，本合同终止。"
    },
    {
      title: "全残保险金（100%基本保额）",
      desc:
        "被保险人因意外原因或于本合同生效(或合同效力恢复)之日起90日后因非意外导致身故或身体全残，保险公司根据保险条款给付身故或全残保险金，本合同终止。被保险人于本合同生效(或合同效力恢复)之日起90日内因非意外导致身故或身体全残，保险公司退还实际已交保费，本合同终止。"
    }
  ]
};
