const path = require("path");
const resolve = dir => path.join(__dirname, dir);
const IS_PROD = process.env.NODE_ENV === 'production';

module.exports = {
  chainWebpack: config => {
    // 修复HMR
    config.resolve.symlinks(true);
    
    // 移除 prefetch 插件(针对生产环境首屏请求数进行优化)
    config.plugins.delete('prefetch')

    // 移除 preload 插件(针对生产环境首屏请求数进行优化)   preload 插件的用途：https://cli.vuejs.org/zh/guide/html-and-static-assets.html#preload
    config.plugins.delete('preload')

    // 添加别名
    config.resolve.alias
      .set("@", resolve("src"))

    return config;
  },
  lintOnSave: true,
  runtimeCompiler: false, // 是否使用包含运行时编译器的 Vue 构建版本
  productionSourceMap: IS_PROD, // 生产环境的 source map
};