/* eslint-disable */
/*
 * //TODO 后期可以做成json文件，以减小包体积
 * @Description: 泰康600万医疗保障
 * @Date: 2020-07-27 15:46:37
 * @LastEditors: gzw
 * @LastEditTime: 2020-08-21 20:15:58
 */

import goodsBg from "@/assets/images/goods/detail/yiliaoxian/bg.png";
import intro01 from "@/assets/images/goods/detail/zhongjixian/intro-01.png";
import intro02 from "@/assets/images/goods/detail/zhongjixian/intro-02.png";
import intro03 from "@/assets/images/goods/detail/zhongjixian/intro-03.png";
import intro04 from "@/assets/images/goods/detail/zhongjixian/intro-04.png";

export default {
  type: "mi",
  productNo: "TKYLX001",
  headerInfo: {
    bgSrc: goodsBg,
    type: "taikang",
    company: "泰康在线",
    title: "1000万医疗保障",
    sub: "责任内100%报销住院医疗费",
    price: [1, "元", "首月"],
    subPrice: [3.6, "元/月起", "次月", "（共11期）"],
    insuredNum: 0,
    stamp: true
  },
  introImg: [intro01, intro02, intro03, intro04],
  companyInfo: [
    { content: "承保公司：泰康财产保险有限公司", offset: false },
    { content: "经营范围：短期健康保险和意外伤害保险", offset: false },
    { content: "备案名称：华泰财险重大疾病保险条款", offset: false },
    { content: "备案编号：C00015431912018061501152；", offset: false }
  ],
  navBarOptions: [
    { label: "我要投保", value: "insure" },
    { label: "产品特色", value: "intro" },
    { label: "理赔说明", value: "process" }
  ],
  autoCellInfo: [
    { title: "【省心】自动续保，不用担心续保不及时导致保障中断", value: "" },
    { title: "【放心】开通自动续保后，可随时取消", value: "" },
    { title: "【安心】自动续保按费率可自动扣费", value: "" },
    {
      title: {
        needSlot: true,
        tpl: " 阅读并同意<a href='javascript:;'>《自动续保服务协议》</a>"
      },
      value: ""
    }
  ],
  planCellInfo: [
    { title: "以下4项保险金，汇总后的年度累计赔付限额600万元", value: "", inline: true },
    { title: "重大疾病医疗保险金", value: "600万" },
    { title: "一般医疗保险金", value: "300万" },
    { title: "质子重离子医疗保险金", value: "600万" },
    { title: "恶性肿瘤院外特定药品费用保险金", value: "600万" },
    { title: "", value: "", divider: true },
    { title: "发生以下治疗费用，获额外400万年度累计限额的赔付", value: "", inline: true },
    { title: "恶性肿瘤特定治疗保险金/康复医疗保险金", value: "400万" },
    { title: "", value: "", divider: true },
    { title: "发生以下指定费用，赔付不超过对应限额", value: "", inline: true },
    { title: "指定检查费用保险金", value: "5000元" },
    { title: "特定疾病保险金", value: "5000元" },
    { title: "", value: "", divider: true },
    { title: "免费增值服务", value: "", inline: true },
    { title: "押金垫付", value: "住院费用垫付服务" },
    { title: "就医绿色通道", value: "全国1233家知名三甲医院" }
  ],
  planTipOptions: ["不限社保", "报销自费药", "额外400万特定赔付"],
  insuredOptions: [
    { label: "本人", value: "1" },
    { label: "父母", value: "2" },
    { label: "配偶", value: "3" },
    { label: "子女", value: "4" }
  ],
  medicalOptions: [
    { label: "有<small style='color: #999;font-size: 11px'>（含新农合）</small>", value: "1" },
    { label: "无", value: "0" }
  ],
  paywayOptions: [
    { label: "月缴<small style='color: #999;font-size: 11px'>（12期）</small>", value: "1" },
    { label: "一次交清", value: "2" }
  ],
  noticeCellInfo: [
    { title: "投保年龄", value: `30~65周岁` },
    { title: "保障期限", value: "1年（可续保至99周岁）" },
    { title: "等待期", value: "30天" },
    {
      title: "保费",
      value: {
        needSlot: true,
        tpl: "保费于被保人年龄、有无社保有关<br />首月1元，次月3.6元/月起"
      }
    }
  ],
  popupArray: [
    {
      title: "保险条款",
      url: "http://mangguo-contract.qthbx.com/tai-kang-bai-mo-yi-liao-bao-xian-tiao-kuan-v1/"
    },
    {
      title: "健康告知",
      url: "http://mangguo-contract.qthbx.com/taikang-jian-kang-gao-zhi-v1/"
    },
    {
      title: "投保须知及声明",
      url: "http://mangguo-contract.qthbx.com/tai-kang-bai-mo-yi-liao-tou-bao-xu-zhi-ji-sheng-ming-v1/"
    },
    {
      title: "平台服务协议",
      url: "http://mangguo-contract.qthbx.com/fu-wu-xie-yi-v1/"
    },
    { title: "保险计划" },
    { title: "理赔信息" },
    { title: "完整费率" },
    {
      title: "自动续保服务协议",
      url: "http://mangguo-contract.qthbx.com/zi-dong-xu-bao-fu-wu-xie-yi-v1/"
    }
  ],
  protocolData: [
    { title: "保险条款", id: 0 },
    { title: "健康告知", id: 1 },
    { title: "投保须知及声明", id: 2 },
    { title: "平台服务协议", id: 3 }
  ],
  caseInfo: {
    name: "吴先生",
    info: "46岁 北京 有社保",
    list: [
      {
        title: "投保",
        event: "2018年6月29日，吴先生为自己投保了一份万家保·重疾轻症险，保额20万，并续保。"
      },
      {
        title: "投保",
        event: "2019年9月16日，吴先生意外烫伤双下肢皮肤，达到浅Ⅲ°烧伤，烧伤面积达20"
      },
      {
        title: "轻症理赔",
        event: "2019年9月17日，吴先生后向我司报案，经核实符合该保险中轻症“特定面积Ⅲ度烧伤”的诊断赔付标准，给予4万保险金赔付。"
      },
      {
        title: "重疾理赔",
        event: "2020年1月3日，吴先生突发胸痛咯血，后诊断为右肺非小细胞性肺癌，经我司核实后确认为保险责任，一次性给予20万元的重大疾病保险金。"
      }
    ]
  },
  qaInfo: [
    {
      q: "这个产品的等待期是多久？",
      a: "本产品的等待期为90天,意外及续保无等待期。"
    },
    {
      q: "如果同时购买了其他重疾险，可以赔付2次吗？",
      a: "本保险产品为一次性给付型产品，如果您购买的重疾险为一次性给付型或报销型产品，可以和本保险同时申请理赔，获得两份赔偿。如果出险，请拨打华泰财险24小时客服电话4006095509。"
    },
    {
      q: "这款产品提供了哪些保障？",
      a: "本产品对人一生中可能罹患的99%以上的100种重大疾病提供保障，同时还有40种轻症保障也包含在内。在保险期间内，被保险人因意外伤害或在等待期后因疾病初次确诊罹患本产品定义的重大疾病或轻症的，即可获得一笔保险补偿。"
    },
    {
      q: "被保险人有哪些限制？",
      a: "可以为出生满30天-60周岁（含）身体健康，且符合健康告知提及状况的本人、配偶、子女或父母投保。"
    },
    {
      q: "理赔后是否可以续保？需要重新完成健康告知吗？",
      a: "无理赔或者已理赔过轻症的第二年可以续保；已理赔过重症的第二年不可以续保；续保无需重新填写健康告知。"
    },
    {
      q: "如何在华泰官网进行保单验真？",
      a: "请登录投保成功短信中提示的华泰官网查询网http://agt.ehuatai.com/nonautoquery/。填写登录信息时，类别选择“家庭财产、意外伤害保险”，保单号在投保成功的短信中，密码填写被保险人身份证号，即可登录查询保单承保信息。"
    }
  ],
  processDetail: [
    {
      title: "电话报案",
      desc: "拨打泰康在线专属服务热线4000795522报案。"
    },
    {
      title: "提交资料",
      desc: `关注「泰康在线保险服务」微信公众号，验证身份信息后，填写被保险人出险信息，并完成上传理赔材料。保险公司审核通过后，通知客户寄送纸质理赔原件。`
    }
  ],
  rateInfo: [
    {
      title: "按月交费",
      th: ["投保年龄", "有社保", "无社保"],
      age: [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65],
      list: [
        [891.8, 833.6, 785.8, 715.9, 690.4, 498.6, 424.4, 374.7, 355.6, 342.9, 338.6, 206.2, 175.4, 143.6, 156.3, 169, 181.8, 194.5, 206.1, 214.6, 222, 244.4, 252.9, 261.4, 263.5, 267.7, 286.8, 293.2, 301.6, 310.1, 329.2, 368, 398.8, 414.7, 438, 451.8, 481.2, 505.6, 519.3, 539.5, 557.5, 579.1, 616.3, 653.3, 683, 713.8, 781.7, 838.9, 886.7, 939.7, 989.4, 1041.2, 1095.2, 1187.5, 1256.3, 1314.7, 1399.4, 1467.3, 1561.7, 1600.8, 1706.8, 1938.5, 2105, 2256.5, 2447.3, 2628.6],
        [1887.2, 1726.1, 1630.7, 1483.3, 1387.9, 996.8, 822, 717, 685.2, 649.2, 634.3, 411.8, 348.2, 282.5, 304.7, 325.9, 351.4, 371.4, 396.9, 416, 446.8, 492.4, 509.4, 532.7, 557.2, 584.7, 636.6, 648.2, 686.4, 719.3, 751.1, 864.1, 907.6, 951, 989.2, 1060.3, 1116.2, 1243.4, 1316.4, 1382.2, 1495.6, 1657.2, 1840.5, 2008, 2110.9, 2239.1, 2380.2, 2608.1, 2799.9, 2924, 3002.4, 3375.3, 3581, 3701.8, 3872.4, 3957.2, 4458.6, 4676, 4841.3, 5044.8, 5350.1, 6128.8, 6828.4, 7413.5, 7866, 8091.9]
      ]
    },
    {
      title: "一次交清",
      th: ["投保年龄", "有社保", "无社保"],
      age: [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65],
      list: [
        [88.5, 82.6, 77.9, 71, 68.4, 49.4, 42, 37.1, 35.2, 33.8, 33.4, 20.4, 17.3, 14.1, 15.4, 16.7, 17.9, 19.3, 20.4, 21.3, 22, 24.2, 25.1, 25.9, 26.1, 26.6, 28.3, 29, 29.8, 30.7, 32.6, 36.5, 39.6, 41.1, 43.4, 44.8, 47.6, 50, 51.4, 53.4, 55.3, 57.3, 61.1, 64.7, 67.6, 70.8, 77.5, 83.2, 87.9, 93.2, 98.1, 103.3, 108.7, 117.9, 124.7, 130.5, 138.8, 145.5, 154.9, 158.8, 169.3, 192.4, 208.9, 223.9, 242.8, 260.9, 88.5],
        [187.3, 171.2, 161.7, 147.1, 137.6, 98.9, 81.5, 71.1, 67.9, 64.3, 62.8, 40.8, 34.5, 27.9, 30.2, 32.3, 34.8, 36.8, 39.3, 41.2, 44.3, 48.8, 50.5, 52.9, 55.3, 57.9, 63.2, 64.3, 68.1, 71.3, 74.5, 85.7, 90, 94.3, 98.2, 105.2, 110.7, 123.3, 130.6, 137, 148.3, 164.4, 182.6, 199.2, 209.4, 222.1, 236.2, 258.8, 277.9, 290.2, 297.9, 335, 355.5, 367.4, 384.4, 392.7, 442.5, 464, 480.4, 500.7, 531, 608.4, 677.8, 735.9, 780.8, 803.3, 187.3, 171.2]
      ]
    }
  ],
  planInfo: [
    {
      title: "重大疾病医疗保险金",
      desc:
        "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX"
    },
    {
      title: "一般医疗保险金",
      desc:
        "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX"
    },
    {
      title: "质子重离子医疗保险金",
      desc:
        "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX"
    },
    {
      title: "恶性肿瘤院外特定药品费用保险金",
      desc:
        "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX"
    },
    {
      title: "恶性肿瘤特定治疗保险金",
      desc:
        "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX"
    },
    {
      title: "康复医疗保险金",
      desc:
        "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX"
    },
    {
      title: "指定检查费用保险金",
      desc:
        "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX"
    },
    {
      title: "特定疾病保险金",
      desc:
        "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX"
    },
    {
      title: "押金垫付",
      desc:
        `"XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX"`
    },
    {
      title: "就医绿色通道",
      desc: `
          <p><strong>1、专业导诊（1次/年）</strong></p>
          <p>为被保险人提供专业导诊咨询服务，帮助用户找“对”专家</p>
          <p><strong>2、专家门诊（1次/年）</strong></p>
          <p>为被保险人提供副主任及以上专家普通/特需门诊的预约服务</p>
          <p><strong>3、专业陪诊（1次/年）</strong></p>
          <p>安排医学专业人员陪伴被保险人，协助完成导诊、检查、取药等全程就医环节</p>
          <p><strong>4、快速住院（1次/年）</strong></p>
          <p>安排被保险人快速入住病房</p>
          <p><strong>5、专家手术（1次/年）</strong></p>
          <p>为被保险人提供专家手术加急服务</p>
      `,
      options: [
        { title: "查看详情", type: "page", path: "/goods/plan?type=mi-more" }
      ]
    }
  ],
  greenInfo: [
    {
      title: "服务介绍",
      desc:
        "当被保险人经二级或二级以上公立医院初次诊断罹患保险合同所定义的100种重大疾病时，如需专家诊疗，可申请重疾快速就医服务。我们将协调安排覆盖全国31个省市的1233家国内知名三甲医院的专家为被保险人提供全面、详尽的诊疗服务。"
    },
    {
      title: "服务医院列表",
      desc:"",
      options: [
        {
          title: "1233家知名三甲医院",
          content:
          `
          <table class="table">
            <thead>
              <tr>
                <th style="width: 25%">省份</th>
                <th style="width: 30%">地区</th>
                <th style="width: 45%">医院名称</th>
              </tr>
            </thead>
            <tbody>
              <tr>
                <td>黑龙江</td>
                <td>七台河</td>
                <td>七台河矿业精煤(集团)有限责任公司总医院</td>
              </tr>
              <tr>
                <td>黑龙江</td>
                <td>七台河</td>
                <td>七台河市人民医院</td>
              </tr>
              <tr>
                <td>黑龙江</td>
                <td>齐齐哈尔</td>
                <td>七台河矿业精煤(集团)有限责任公司总医院</td>
              </tr>
            </tbody>
            </table>
          `
        }
      ]
    },
    {
      title: "服务内容",
      desc:
      `
      <p><strong>1、专业导诊（1次/年）</strong></p>
      <p>为被保险人提供专业导诊咨询服务，帮助用户找“对”专家</p>
      <p><strong>2、专家门诊（1次/年）</strong></p>
      <p>为被保险人提供副主任及以上专家普通/特需门诊的预约服务</p>
      <p><strong>3、专业陪诊（1次/年）</strong></p>
      <p>安排医学专业人员陪伴被保险人，协助完成导诊、检查、取药等全程就医环节</p>
      <p><strong>4、快速住院（1次/年）</strong></p>
      <p>安排被保险人快速入住病房</p>
      <p><strong>5、专家手术（1次/年）</strong></p>
      <p>为被保险人提供专家手术加急服务</p>
      `
    },
    {
      title: "服务安排时间",
      desc:
        `
      <table class="table">
      <thead>
        <tr>
          <th>服务项目</th>
          <th>服务安排时间</th>
        </tr>
      </thead>
      <tbody>
        <tr>
          <td>专业导诊</td>
          <td>1个工作日</td>
        </tr>
        <tr>
          <td>专家门诊、专业陪诊</td>
          <td>5个工作日</td>
        </tr>
        <tr>
          <td>快速住院、专家手术</td>
          <td>10个工作日</td>
        </tr>
      </tbody>
      </table>
        `
    },
    {
      title: "服务有效期",
      desc:
        "保单有效期内有效"
    },
    {
      title: "服务流程",
      desc:
      `
      <p>1、申请：拨打泰康在线服务热线400-079-5522；</p>
      <p>2、审核：补充病例材料，服务资格审核；</p>
      <p>3、服务：根据病例材料及被保险人需求提供专业导诊咨询，安排专家门诊、专业陪诊、快速住院、专家手术。</p>
      `
    }
  ]
};
