import { payByWay } from "@/service/pay";
import { isXyqb, isWeixinBrower } from "@/service/validation";
import { placeOrder } from "@/api/product";

export default {
  data() {
    return {
      subFromData: {}, // 组装好的数据
      orderInfo: {},
      tradeType: ""
      // customTradeType: ""
    };
  },
  created() {
    this.tradeType = this.customTradeType ?? (isXyqb ? "MWEB" : isWeixinBrower ? "JSAPI" : "MWEB");
  },
  methods: {
    async generateOrder() {
      const res = await placeOrder.create({
        ...this.subFromData
      });
      if (res) {
        this.orderInfo = res;
        this.goPay();
      }
    },
    async goPay() {
      const { tradeType, orderInfo } = this;
      const { payOrderNo, payType, orderNo } = orderInfo;
      if (!payOrderNo) {
        this.$toast("请先生成订单");
        return;
      }
      const res = await placeOrder.pay({ payOrderNo, payType, tradeType });
      if (res) {
        let payInfo = {
          url: res.payUrl,
          params: {
            ...orderInfo,
            tradeType,
            state: 1
          }
        };
        if (tradeType === "JSAPI") {
          payInfo = res.payInfo;
        }
        payByWay(tradeType, payInfo).then(() => {
          this.$router.push({ url: "/policy/detail", query: { id: orderNo } });
        });
      }
    }
  }
};
