import Vue from "vue";
import Vuex from "vuex";
import user from "./modules/user";
import { isXyqb } from "@/service/validation";
import localStorage from "@/service/localStorage";

const XYQB_AUTH_STATE = localStorage.get("xyqbAuthState") || 1;
Vue.use(Vuex);

export default new Vuex.Store({
  state: {
    activeIdx: 0,
    isLoading: false,
    isShowLogin: false,
    showAuthXyqb: isXyqb ? XYQB_AUTH_STATE : -1 // 1 已获取信息未授权，2 打开授权弹框， 3 拒绝授权，4 允许授权, -1 非信用钱包环境
  },
  mutations: {
    setActiveIdx(state, value) {
      state.activeIdx = value;
    },
    setIsLoading(state, value) {
      state.isLoading = value;
    },
    setIsShowLogin(state, value) {
      state.isShowLogin = value;
    },
    setAuthXyqb(state, value) {
      state.showAuthXyqb = value;
      localStorage.set("xyqbAuthState", value);
    }
  },
  actions: {
    setActiveIdx({ commit }, args) {
      commit("setActiveIdx", args);
    },
    setIsLoading({ commit }, args) {
      commit("setIsLoading", args);
    },
    setIsShowLogin({ commit }, args) {
      commit("setIsShowLogin", args);
    },
    setAuthXyqb({ commit }, args) {
      commit("setAuthXyqb", args);
    }
  },
  modules: {
    user
  }
});
