import getWxShareInfo from "@/service/wxJsSdk";
const currentOrigin = window.location.origin;
const logo = currentOrigin + "/shareImg/index.png";
const shareList = {
  home: {
    title: "【芒果保险】好保险，省钱买",
    desc:
      "	「芒果保险」是专注于健康保障的互联网保险严选平台，为用户挑选性价比高、更适合自己的保险产品，让每个家庭都有备无患。",
    url: currentOrigin + "/home",
    imgUrl: logo
  },
  smartmeasure: {
    title: "【芒果保险】智能风险评测",
    desc: "「芒果保险」不知道怎么买保险？AI小果为您提供30S快速评测，推荐最适合你的保险。",
    url: currentOrigin + "/home/smart-measure",
    imgUrl: currentOrigin + "/shareImg/ai.png"
  },
  activity: {
    title: "最高18888元红包 抽!抽!抽！",
    desc: "100%中奖！「芒果保险」老用户专享，参与投票即可抽取最高18888元红包",
    url: currentOrigin + "/home/activity",
    imgUrl: currentOrigin + "/shareImg/activity.jpg"
  },
  goods: {
    title: "【芒果保险】好保险，省钱买",
    desc:
      "「芒果保险」是专注于健康保障的互联网保险严选平台，为用户挑选性价比高、更适合自己的保险产品，让每个家庭都有备无患。",
    url: currentOrigin + "/goods",
    imgUrl: logo
  },
  consultant: {
    title: "【芒果保险】限时优惠！0.99元聘请芒果保险顾问，1对1量身定制",
    desc:
      "「芒果保险」1对1保险顾问，帮您最高节省50%保费，为你量身选保险！顾问团队是由资深保险精算师组成，将秉承中立客观的服务态度，进行条款解读。",
    url: currentOrigin + "/consultant",
    imgUrl: currentOrigin + "/shareImg/advisor.png"
  },
  user: {
    title: "【芒果保险】好保险，省钱买",
    desc:
      "「芒果保险」是专注于健康保障的互联网保险严选平台，为用户挑选性价比高、更适合自己的保险产品，让每个家庭都有备无患。",
    url: currentOrigin + "/user",
    imgUrl: logo
  },
  midetail: {
    title: "【芒果保险】万家保·百万医疗险",
    desc:
      "「报销型医疗险」最高600万全面医疗保障，120种重大疾病医疗0免赔，30天~65周岁均可保，70种抗癌特药定期上新，免费提供住院费用垫付服务等一站式就医服务。",
    imgUrl: currentOrigin + "/shareImg/goods-01.png"
  },
  ciidetail: {
    title: "【芒果保险】万家保·重疾轻症险",
    desc:
      "「给付型重疾险」100种重症+40种轻症确诊即赔，轻症赔付后，重疾保障继续有效。30天~60周岁均可保。",
    imgUrl: currentOrigin + "/shareImg/goods-02.png"
  },
  aidetail: {
    title: "【芒果保险】万家保·综合意外险",
    desc: "「给付型意外险」意外风险覆盖全，保额最高100万，猝死也可赔。",
    imgUrl: currentOrigin + "/shareImg/goods-03.png"
  },
  lidetail: {
    title: "【芒果保险】华贵大麦2020定期寿险",
    desc:
      "「定期寿险」家庭主要收入贡献者的必备保险，最高可赔350万。免体检，责任免除仅3条，1~6类职业均可保，健康告知仅3条。",
    imgUrl: currentOrigin + "/shareImg/goods-04.png"
  },
  policydetail: {
    title: "【芒果保险】好保险，省钱买",
    desc:
      "「芒果保险」是专注于健康保障的互联网保险严选平台，为用户挑选性价比高、更适合自己的保险产品，让每个家庭都有备无患。",
    url: currentOrigin + "/user",
    imgUrl: logo
  }
};

export const getShare = to => {
  let shareName = to.name;
  let _path = to.path;
  if (_path.includes("activity")) {
    shareName = "activity";
  } else if (_path.includes("smart-measure")) {
    shareName = "SmartMeasure";
  } else if (_path.includes("consultant")) {
    shareName = "consultant";
  } else if (_path.includes("smart-measure")) {
    shareName = "SmartMeasure";
  } else if (to.name === "GoodsDetail") {
    shareName = to.query.type + "detail";
  } else if (_path.includes("goods") || to.name === "AddPolicy") {
    shareName = "Goods";
  } else if (to.name === "PolicyDetail") {
    shareName = "policydetail";
  } else if (_path.includes("user") || _path.includes("policy")) {
    shareName = "User";
  } else {
    shareName = "home";
  }
  const _name = shareName.toLowerCase();
  if (shareList[_name]) {
    getWxShareInfo(shareList[_name]);
  }
};
