import { getElectronicInsurance } from "@/api/policy";

export default {
  methods: {
    async getElectronicInsurance(policySecId) {
      if (!policySecId) {
        this.$notify({ type: "warning", message: "保单不存在" });
        return;
      }
      const { url } = await getElectronicInsurance({ policySecId });
      if (!url) {
        this.$notify({ type: "danger", message: "保单地址返回异常" });
        return;
      }
      this.$router.push({
        path: "/policy/virtual-detail",
        query: { url }
      });
    }
  }
};
