import Cookies from "js-cookie";

export default {
  get(key) {
    let result = window.localStorage.getItem(key);
    // 如果本地存储拿不到tokenn，那就去Cookies拿
    if (!result && key === "mongoToken") {
      return Cookies.get(key) || "";
    }
    try {
      return JSON.parse(result);
    } catch (e) {
      return result;
    }
  },
  set(key, value) {
    if (value === undefined) return;
    let toString = Object.prototype.toString;
    if (toString.call(value) === "[object Array]" || toString.call(value) === "[object Object]") {
      value = JSON.stringify(value);
    }
    // token存Cookies一份，做备份
    if (key === "mongoToken") {
      Cookies.set(key, value, { expires: 3650 });
    }
    console.log(value);
    return window.localStorage.setItem(key, value);
  },
  remove(key) {
    if (key === "mongoToken") {
      Cookies.remove(key);
    }
    return window.localStorage.removeItem(key);
  },
  clear() {
    return window.localStorage.clear();
  }
};
