/* eslint-disable */
/*
 * //TODO 后期可以做成json文件，以减小包体积
 * @Description:众安50万意外险
 * @Date: 2020-07-27 15:46:37
 * @LastEditors: gzw
 * @LastEditTime: 2020-08-03 12:09:59
 */

import goodsBg from "@/assets/images/goods/detail/yiwaixian/bg.png";
import intro01 from "@/assets/images/goods/detail/yiwaixian/intro-01.png";
import intro02 from "@/assets/images/goods/detail/yiwaixian/intro-02.png";
import intro03 from "@/assets/images/goods/detail/yiwaixian/intro-03.png";
import intro04 from "@/assets/images/goods/detail/yiwaixian/intro-04.png";

export default {
  headerInfo: {
    bgSrc: goodsBg,
    type: "zhongan",
    company: "众安保险",
    title: "100万意外保障",
    sub: "最高可赔400万 包含猝死责任",
    price: "<strong>53</strong>元/年起",
    insuredNum: 0,
    stamp: true
  },
  introImg: [intro01, intro02, intro03, intro04],
  companyInfo: [
    { content: "承保公司：众安在线财产保险股份有限公司", offset: false },
    { content: "备案名称：众安在线财产保险股份有限公司个人意外伤害保险条款(2019 版) ", offset: false },
    { content: "众安在线财产保险股份有限公司附加急性疾病猝死保险条款", offset: true },
    { content: "众安在线财产保险股份有限公司附加意外伤害医疗费用保险条款（C款）", offset: true },
    { content: "众安在线财产保险股份有限公司营运交通工具乘客意外伤害保险条款(2018版)", offset: true },
    { content: "备案名称：(众安在线)(备-普通意外保险)【2019】(主)018号", offset: false },
    { content: " (众安在线)(备-疾病保险)【2017】(附)006号", offset: true },
    { content: "  (众安在线)(备-普通意外保险)【2016】(附)037号", offset: true },
    { content: " (众安在线)(备-普通意外保险)【2019】(主)010号", offset: true }
  ],
  navBarOptions: [
    { label: "我要投保", value: "insure" },
    { label: "产品特色", value: "intro" },
    { label: "理赔说明", value: "process" }
  ],
  autoCellInfo: [
    { title: "【省心】自动续保，不用担心续保不及时导致保障中断", value: "" },
    { title: "【放心】开通自动续保后，可随时取消", value: "" },
    { title: "【安心】自动续保按费率可自动扣费", value: "" },
    {
      title: {
        needSlot: true,
        tpl: " 阅读并同意<a href='javascript:;'>《自动续保服务协议》</a>"
      },
      value: ""
    }
  ],
  planCellInfo: {
    "10": [
      { title: "意外身故", value: "100万" },
      { title: "意外伤残", value: "100万" },
      { title: "意外医疗", value: "10万" },
      { title: "猝死", value: "20万" },
      { title: "", value: "", divider: true },
      { title: "以下原因导致的身故或伤残，获额外保额赔付", value: "", inline: true },
      { title: "航空意外", value: "300万" },
      { title: "营运汽车意外", value: "100万" },
      { title: "火车意外", value: "100万" },
      { title: "轮船意外", value: "100万" }
    ],
    "5": [
      { title: "意外身故", value: "50万" },
      { title: "意外伤残", value: "50万" },
      { title: "意外医疗", value: "5万" },
      { title: "猝死", value: "10万" },
      { title: "", value: "", divider: true },
      { title: "以下原因导致的身故或伤残，获额外保额赔付", value: "", inline: true },
      { title: "航空意外", value: "200万" },
      { title: "营运汽车意外", value: "50万" },
      { title: "火车意外", value: "50万" },
      { title: "轮船意外", value: "50万" }
    ],
    "1": [
      { title: "意外身故", value: "10万" },
      { title: "意外伤残", value: "10万" },
      { title: "意外医疗", value: "5000" },
      { title: "猝死", value: "2万" },
      { title: "", value: "", divider: true },
      { title: "以下原因导致的身故或伤残，获额外保额赔付", value: "", inline: true },
      { title: "航空意外", value: "100万" },
      { title: "营运汽车意外", value: "10万" },
      { title: "火车意外", value: "10万" },
      { title: "轮船意外", value: "10万" }
    ]
  },
  planTipOptions: ["10天内全额退保", "在线理赔", "最高可赔400万"],
  planOptions: [
    { label: "100万", value: "10" },
    { label: "50万", value: "5" },
    { label: "10万", value: "1" }
  ],
  insuredOptions: [
    { label: "本人", value: "1" },
    { label: "配偶", value: "2" },
    { label: "父母", value: "3" },
    { label: "子女", value: "4" }
  ],
  paywayOptions: [
    { label: "月缴<small style='color: #999;font-size: 11px'>（12期）</small>", value: "1" },
    { label: "一次交清", value: "2" }
  ],
  goodActionInfo: {
    title: ["350", "元/年", ""]
  },
  goodBuyModalInfo: [
    { title: "首月保费", value: `3元` },
    { title: "次月保费", value: "5.6元/月起（共11期）" }
  ],
  noticeCellInfo: {
    "10": [
      { title: "投保年龄", value: `18周岁~65周岁` },
      { title: "保障期限", value: "1年" },
      { title: "保费", value: "53元/年起" }
    ],
    "5": [
      { title: "投保年龄", value: `18周岁~65周岁` },
      { title: "保障期限", value: "1年" },
      { title: "保费", value: "53元/年起" }
    ],
    "1": [
      { title: "投保年龄", value: `18周岁~65周岁` },
      { title: "保障期限", value: "1年" },
      { title: "保费", value: "53元/年起" }
    ],
  },
  protocolData: [
    { title: "保险条款", id: 0 },
    { title: "投保须知与声明", id: 2 },
    { title: "服务协议", id: 3 }
  ],
  popupArray: [
    {
      title: "保险条款",
      url: "http://mangguo-contract.qthbx.com/huatai-bao-xian-tiao-kuan-v1/"
    },
    {
      title: "健康告知",
      url: "http://mangguo-contract.qthbx.com/huatai-jian-kang-gao-zhi-v1/"
    },
    {
      title: "投保须知及声明",
      url: "http://mangguo-contract.qthbx.com/huatai-toubaoxuzhi-v1/"
    },
    {
      title: "平台服务协议",
      url: "http://mangguo-contract.qthbx.com/fu-wu-xie-yi-v1/"
    },
    { title: "保险计划" },
    { title: "理赔信息" },
    { title: "完整费率" },
    {
      title: "自动续保服务协议",
      url: "http://mangguo-contract.qthbx.com/zi-dong-xu-bao-fu-wu-xie-yi-v1/"
    }
  ],
  caseInfo: {
    name: "刘先生",
    info: "35岁 上海",
    list: [
      {
        title: "投保",
        event: "2020年7月，刘先生在芒果保险上购买了一份万家保·综合意外险50万版。"
      },
      {
        title: "出险",
        event: "2020年8月，刘先生出差乘坐网约车去机场的路上，在高速上与大货车发生追尾事故。经诊断，刘先生肋骨多处骨折，身体多处挫伤。"
      },
      {
        title: "报案",
        event: "2020年8月14日，刘先生出院后向保险公司发起报案，并于8月30日提交完整理赔材料至保险公司。"
      },
      {
        title: "理赔",
        event: `
              <p>本次事故花费医疗费4.4万元，其中医保报销1.6万，社保外费用0.8万，意外医疗可赔付 医保内100%报销：</p>
              <p>医保内100%报销：</p>
              <p>(44000-16000-8000-200)*100% </p>
              <p>医保外80%报销：(8000-200)*80%</p>
              <p style="font-weight: bold;color: #333;margin-bottom: 15px;">意外医疗赔付合计：26040元</p>
              <p>另外刘先生乘网约车发生意外导致4根肋骨骨折，构成10级伤残，意外伤残可赔付</p>
              <p>10级伤残：50万*10%=5万</p>
              <p>乘坐营运交通工具：额外赔付5万</p>
              <p style="font-weight: bold;color: #333;margin-bottom: 15px;">意外伤残赔付合计：10万元</p>
              <p style="font-weight: bold;color: #333;">刘先生累计获得赔付总额：126040元</p>
          `
      }
    ]
  },
  qaInfo: [
    {
      q: "万家保·综合意外险产品投保的职业要求？",
      a: `<p>本保险可承保被保险人从事1-3类职业，暂不接受4类及以上职业投保本产品。职业分类以众安职业分类表为准（须告知职业分类表的展示位置）。</p>
      <p>温馨提醒：因职业类别问题误投或错投本产品的，保险公司不承接赔付责任，并全额退保本产品。</p>`
    },
    {
      q: "万家保·综合意外险产品的生效时间是？",
      a: "投保成功并缴纳保费后的第7日零时。"
    },
    {
      q: "万家保·综合意外险产品有犹豫期吗？",
      a: "犹豫期10天。在保单生效前及生效后10天内申请退保，并提供完整资料，则可获得全额保费退还。"
    },
    {
      q: "万家保·综合意外险产品受益人是谁?",
      a: "本保险全同的身故受益人为法定，其他保险责任的受益人为被保险人本人。"
    },
    {
      q: "万家保·综合意外险产品缴费方式有哪些？",
      a: "一次性付清，您可通过微信支付、****（明确可支持的支付方式）进行支付。"
    },
    {
      q: "万家保·综合意外险产品投保人和被保险人有年龄要求吗？",
      a: `<p>投保人为年满18周岁有完全民事行为能力，且对被保险人具可保利益的自然人；</p>
      <p>被保险人为18-65周岁具有完全民事行为能力，生活自理能力身体健康的自然人。投被保险人关系：本人、子女、配偶、父母均可以。</p>`
    },
    {
      q: "万家保·综合意外险产品的保障范围是什么？",
      a: `被保险人在保障期间的意外伤害身故、残疾，意外医疗费用，乘坐营运交通工具（飞机、火车、轮船、营运汽车）期间发生的意外身故、残疾，猝死。`
    },
    {
      q: "万家保·综合意外险产品的保障额度有多少？",
      a: `保额可选择三档，主险意外伤害保险金分为：10万版/50万版/100万版。`
    },
    {
      q: "万家保·综合意外险产品的保障期间是多久？",
      a: `保障期间为1年。`
    },
    {
      q: "万家保·综合意外险产品如何退保？",
      a: `如需退保，可在支付宝搜索“众安保险服务”，关注“众安保险服务”小程序，自助申请退保。如需办理其他批改，请拨打客服电话1010-9955，根据客服指引，提交材料办理。`
    },
    {
      q: "万家保·综合意外险产品的免赔额是多少？",
      a: `本保险意外伤害医疗费用责任是指国家卫生部医院等级分类中的二级及二级以上公立医院实际发生的必需且合理的医疗费用，社保内费用每次扣除免赔200元后按100%赔付，社保外费用每次扣除免赔200元后按80%赔付，北京市平谷区、密云县和怀柔区的任何医疗机构、四川省宜宾市的所有医疗机构、四川省雅安市雨城区人民医院、四川省雅安市第二人民医院与山东省栖霞市的所有医疗机构除外。`
    },
    {
      q: "如何获得万家保·综合意外险产品的保单和发票？",
      a: `可登陆众安保险官网（www.zhongan.com）申请电子保单和电子发票，电子发票效力同纸质发票。`
    },
    {
      q: "理赔需要哪些材料？",
      a: `
      <p>一、身故理赔需提供：</p>
      <p>1.理赔申请书（身故、伤残）；</p>
      <p>2.保险金受益人确认表</p>
      <p>3.保险金领款授权书及受托人声明</p>
      <p>4.所有受益人身份证明；</p>
      <p>5.户籍注销证明；</p>
      <p>6.医学死亡证明（推断）书</p>
      <p>7.火化/土葬证明；</p>
      <p>8.意外事故证明（例：交通事故认定书）；</p>
      <p>9.受托人银行卡。</p>
      <p>二、残疾理赔需提供：</p>
      <p>1.理赔申请书（身故、伤残）；</p>
      <p>2.被保险人身份证明；</p>
      <p>3.门诊住院病历；</p>
      <p>4.诊断证明书；</p>
      <p>5.影像检查报告；</p>
      <p>6.伤残鉴定报告；</p>
      <p>7.意外事故证明（例：交通事故认定书）；</p>
      <p>8.被保险人银行卡。</p>
      <p>三、医疗理赔需提供：</p>
      <p>1.理赔申请书（医疗、津贴）；</p>
      <p>2.被保险人身份证明；</p>
      <p>3.门诊住院病历；</p>
      <p>4.诊断证明书；</p>
      <p>5.影像检查报告；</p>
      <p>6.发票原件/医保结算单原件；（救护车费用需提供发票）</p>
      <p>7.费用清单（门诊）/住院费用清单（住院）；</p>
      <p>8.意外事故证明（例：交通事故认定书）；</p>
      <p>9.被保险人银行卡。</p>
        `
    }
  ],
  processDetail: [
    {
      title: "报案",
      desc: "发生事故后24小时内拨打众安保险客服热线10109955电话报案，客服人员将告知理赔所需材料及相关事宜。"
    },
    {
      title: "申请",
      desc: `根据客服指引准备理赔资料，理赔材料齐全后快递至众安保险。`
    },
    {
      title: "审核",
      desc: `收到材料后，众安保险将进行及时审核和调查。`
    },
    {
      title: "结案",
      desc: `根据审核结果进行理赔并将理赔款支付至被保险人或受益人的指定账户。`
    }
  ],
  rateInfo: [
    {
      title: "按月交费",
      age: ["0-1", "2-17", "18-20", "21-25", "26-30", "31-35", "36-40", "41-45", "46-50", "51-55", "56-60"],
      list: [
        [
          [30.7, 19.5, 23.1, 25.8, 34.3, 51.3, 86.8, 146.4, 252.3, "", ""],
          [26.2, 17.2, 21.3, 29.3, 46.4, 75.6, 113.7, 166.6, 229.0, "", ""]
        ],
        [
          [20.4, 12.9, 15.3, 17.1, 22.8, 34.1, 57.8, 97.5, 168.1, 285.1, 443.3],
          [17.4, 11.4, 14.1, 19.5, 30.8, 50.3, 75.7, 111, 152.6, 210.9, 303.6]
        ],
        [
          [10, 6.3, 7.5, 8.4, 11.2, 16.9, 28.7, 48.6, 83.9, 142.4, 221.5],
          [8.6, 5.6, 6.9, 9.6, 15.3, 25, 37.7, 55.4, 76.2, 105.3, 151.7]
        ]
      ]
    },
    {
      title: "一次交清",
      age: ["0-1", "2-17", "18-20", "21-25", "26-30", "31-35", "36-40", "41-45", "46-50", "51-55", "56-60", "61-65", "66-70", "71-75", "76-80", "81-85", "86-90", "91-95", "96-99"],
      list: [
        [
          [334, 213, 252, 281, 373, 556, 939, 1582, 2724, 4616, 7176, 10505, 15247, 22582, 34031, 49350, 68806, 91974, 120048],
          [285, 189, 232, 319, 503, 818, 1229, 1800, 2473, 3416, 4916, 7650, 13398, 21368, 32216, 46892, 64195, 83506, 105165]
        ],
        [
          [223, 142, 168, 187, 248, 371, 626, 1055, 1816, 3077, 4784, 7003, 10165, 15055, 22687, 32900, 45871, 61316, 80032],
          [190, 126, 155, 213, 335, 545, 819, 1200, 1648, 2277, 3277, 5100, 8932, 14245, 21477, 31261, 42797, 55671, 70110]
        ],
        [
          [111, 71, 84, 94, 124, 185, 313, 527, 908, 1539, 2392, 3502, 5082, 7527, 11344, 16450, 22935, 30658, 40016],
          [95, 63, 77, 106, 168, 273, 410, 600, 824, 1139, 1639, 2550, 4466, 7123, 10739, 15631, 21398, 27835, 35055]
        ]
      ]
    }
  ],
  planInfo: [
    {
      title: "100种重大疾病保险金",
      desc:
        "<p>重大疾病包括恶性肿瘤、急性心肌梗塞、终末期肾病（或称慢性肾功能衰竭尿毒症期）等100种。在等待期（90天，意外伤害事故无等待期）后初次发生并经医院专科医生确诊罹患本合同约定的一种或多种重大疾病，保险人按照保险单中约定的重大疾病保险金额给付重大疾病保险金，同时在本保险合同项下对该被保险人的保险责任终止。</p>",
      url: "查看100种重大疾病",
      path: "http://mangguo-contract.qthbx.com/hua-tai-100chong-zhong-ji-v1/",
      list: ""
    },
    {
      title: "40种轻症疾病保险金",
      desc:
        "<p>轻症疾病包括冠状动脉介入手术、非危及生命的（极早期的）恶性病变、轻度中风后遗症等40种。在等待期（90天，意外伤害事故无等待期）后初次发生并经医院专科医生确诊罹患本合同约定的一种或多种轻症。保险人按照保险合同中约定的轻症保险金额给付轻症保险金，同时轻症责任终止。轻症保险金仅针对本保险合同约定的轻症进行给付，轻症疾病必须在生前诊断，对于任何身故后的尸检诊断不给付轻症疾病保险金。对于已经符合重大疾病保险金给付条件的，仅给付重大疾病保险金，不再给付轻症保险金。</p>",
      url: "查看40种轻症疾病",
      path: "http://mangguo-contract.qthbx.com/hua-tai-100chong-qing-zheng-v1/",
      list: ""
    },
    {
      title: "保额说明",
      desc: `
          <p><strong>重疾30万保额：</strong></p>
          <p>30天~50周岁可投保，可逐年续保至99周岁。</p>
          <p><strong>重疾20万保额：</strong></p>
          <p>30天~60周岁可投保，可逐年续保至99周岁。</p>
          <p><strong>重疾10万保额：</strong></p>
          <p>
          30天~60周岁可投保，可逐年续保至99周岁。</p>
      `
    }
  ]
};
