export default {
  mounted() {
    if (window.history && window.history.pushState) {
      // 向历史记录中插入了当前页
      history.pushState(null, null, document.URL);
      window.addEventListener("popstate", this.goBack, false);
    }
  },
  destroyed() {
    window.removeEventListener("popstate", this.goBack, false);
  },
  methods: {
    goBack() {
      console.log("popstate", history, this.$route);
      // 点击了浏览器的返回按钮
      if (this.$route.name === "PolicyDetail") {
        this.$router.replace("/policy");
      } else if (this.$route.name === "Policy") {
        this.$router.replace("/user");
      }
    }
  }
};
