import Vue from "vue";
import VueRouter from "vue-router";

Vue.use(VueRouter);

const routes = [
  {
    path: "/",
    name: "Default",
    redirect: "/goods"
  },
  {
    path: "/home",
    name: "Home",
    component: () => import("../views/Home/index.vue")
  },
  {
    path: "/home/smart-measure",
    name: "SmartMeasure",
    component: () => import("../views/Home/SmartMeasure/index.vue")
  },
  {
    path: "/goods",
    name: "Goods",
    component: () => import("../views/Goods/index.vue")
  },
  {
    path: "/goods/detail",
    name: "GoodsDetail",
    component: () => import("../views/Goods/Detail/index.vue")
  },
  {
    path: "/goods/plan",
    name: "GoodsPlan",
    component: () => import("../views/Goods/Plan/index.vue")
  },
  {
    path: "/goods/inform",
    name: "GoodsInform",
    component: () => import("../views/Goods/Inform/index.vue")
  },
  {
    path: "/consultant",
    name: "Consultant",
    component: () => import("../views/Consultant/index.vue")
  },
  {
    path: "/consultant/success",
    name: "ConsultantSuccess",
    component: () => import("../views/Consultant/Success/index.vue")
  },
  {
    path: "/consultant/question",
    name: "ConsultantQuestion",
    component: () => import("../views/Consultant/Question/index.vue")
  },
  {
    path: "/consultant/exclusive",
    name: "ConsultantExclusive",
    component: () => import("../views/Consultant/Exclusive/index.vue")
  },
  {
    path: "/consultant/plan",
    name: "ConsultantPlan",
    component: () => import("../views/Consultant/Plan/index.vue")
  },
  {
    path: "/user",
    name: "User",
    component: () => import("../views/User/index.vue")
  },
  {
    path: "/user/family",
    name: "Family",
    component: () => import("../views/User/Family/index.vue")
  },
  {
    path: "/user/family/detail/:id",
    name: "Family",
    component: () => import("../views/User/Family/Detail/index.vue")
  },
  {
    path: "/user/help-center",
    name: "Family",
    component: () => import("../views/User/HelpCenter/index.vue")
  },
  {
    path: "/policy",
    name: "Policy",
    component: () => import("../views/Policy/index.vue")
  },
  {
    path: "/policy/detail",
    name: "Detail",
    component: () => import("../views/Policy/Detail/index.vue")
  },
  {
    path: "/policy/add",
    name: "AddPolicy",
    component: () => import("../views/Policy/Add/index.vue")
  },
  {
    path: "/policy/payment-record",
    name: "PaymentRecord",
    component: () => import("../views/Policy/PaymentRecord/index.vue")
  },
  {
    path: "/policy/renewal",
    name: "Renewal",
    component: () => import("../views/Policy/Renewal/index.vue")
  },
  {
    path: "/introduction",
    name: "Introduction",
    component: () => import("../views/Introduction/index.vue")
  },
  {
    path: "/paytest",
    name: "Introduction",
    component: () => import("../views/paytest")
  },
  {
    path: "*",
    redirect: "/goods"
  }
];

const originalPush = VueRouter.prototype.push;

VueRouter.prototype.push = function push(location) {
  return originalPush.call(this, location).catch(err => err);
};

const router = new VueRouter({
  mode: "history",
  base: process.env.BASE_URL,
  routes,
  scrollBehavior() {
    return { x: 0, y: 0 };
  }
});

export default router;
