import req from "@/service/http";

// 手机号登录
export const loginByPhone = param => {
  return req.post("user/login", param);
};

// 信用钱包用户自动登录
export const authByxyqb = param => {
  return req.get("xyqb_user_info", param);
};

// 微信用户获取openid
export const getwxOpenId = param => {
  return req.post("wechat/code", param);
};

// 获取短信验证码
export const getCaptchaSms = param => {
  return req.post("captcha/sms", param);
};

// 获取图形验证码
export const getCaptchaImg = param => {
  return req.post("captcha/image", param);
};

// 获取用户信息
export const getUserInfo = () => {
  return req.get("user/me");
};

// 查询家人列表
export const getFamilyList = () => {
  return req.get("user/info/list");
};

// 新增个人信息
export const addFamily = param => {
  return req.post("user/info", param);
};

// 修改个人信息
export const updateFamily = param => {
  return req.post("/user/info/update", param);
};

// 修改个人信息
export const delFamily = param => {
  return req.post("/user/info/delete", param);
};
