import Vue from "vue";
import "@/service/load";
import App from "./App.vue";
import router from "./router";
import store from "./store";
import "./style/index.less";
import "amfe-flexible";
import vConsole from "vconsole";
import sa from "sa-sdk-javascript";
import "@/assets/icons/index";
import "@/service/cherry-ui";
import Raven from "raven-js";
import RavenVue from "raven-js/plugins/vue";
import config from "@/config";
import { release } from "../.sentryclirc";

Vue.config.productionTip = false;
new Vue({
  router,
  store,
  render: h => h(App)
}).$mount("#app");

// 初始化sentry
Raven.config("https://1dc603dd7c09468793aa003ab0bf9480@sentry.q-gp.com/57", {
  release,
  environment: process.env.VUE_APP_ENVIRONMENT
})
  .addPlugin(RavenVue, Vue)
  .install();

// 初始化神策
sa.init({
  server_url: config.shenceUrl,
  heatmap: {
    //是否开启点击图，默认 default 表示开启，自动采集 $WebClick 事件，可以设置 'not_collect' 表示关闭
    clickmap: "default",
    //是否开启触达注意力图，默认 default 表示开启，自动采集 $WebStay 事件，可以设置 'not_collect' 表示关闭
    scroll_notice_map: "default"
    //判断外层是否有 App 的 SDK ，如果有的话，会往 App 的 SDK 发数据。如果没有，就正常发送数据。
    // use_app_track: true,
  },
  show_log: config.test
});
// 添加公共属性
sa.registerPage({ platformType: "H5" });
router.afterEach(() => {
  Vue.nextTick(() => {
    sa.quick("autoTrackSinglePage");
  });
});

window.addEventListener(
  "popstate",
  () => {
    router.isBack = true;
  },
  false
);

// if (process.env.NODE_ENV !== "development") {
// ! 上线后务必取掉
new vConsole();
// }
