/*
 * @Description: 支付微信h5, jsapi, 第三方收银台，跳转）
 * @Date: 2020-07-28 15:03:52
 * @LastEditors: gzw
 * @LastEditTime: 2020-07-28 15:20:28
 */

/**
 * payByWeixinJsapi
 * @description: 微信通过jsapi支付
 *               可以在微信浏览器调起支付
 * @param {type}
 * @return:
 */
export function payByWeixinJsapi() {
  function onBridgeReady() {
    // eslint-disable-next-line no-undef
    WeixinJSBridge.invoke(
      "getBrandWCPayRequest",
      {
        appId: "wx2421b1c4370ec43b", //公众号名称，由商户传入
        timeStamp: "1395712654", //时间戳，自1970年以来的秒数
        nonceStr: "e61463f8efa94090b1f366cccfbbb444", //随机串
        package: "prepay_id=u802345jgfjsdfgsdg888",
        signType: "MD5", //微信签名方式：
        paySign: "70EA570631E4BB79628FBCA90534C63FF7FADD89" //微信签名
      },
      function(res) {
        if (res.err_msg == "get_brand_wcpay_request:ok") {
          // 使用以上方式判断前端返回,微信团队郑重提示：
          //res.err_msg将在用户支付成功后返回ok，但并不保证它绝对可靠。
        } else if (res.err_msg == "get_brand_wcpay_request:cancel") {
          // 支付取消
        } else {
          // 支付失败
        }
      }
    );
  }
  if (typeof WeixinJSBridge == "undefined") {
    if (document.addEventListener) {
      document.addEventListener("WeixinJSBridgeReady", onBridgeReady, false);
    } else if (document.attachEvent) {
      document.attachEvent("WeixinJSBridgeReady", onBridgeReady);
      document.attachEvent("onWeixinJSBridgeReady", onBridgeReady);
    }
  } else {
    onBridgeReady();
  }
}

/**
 * payByWeixinH5
 * @description: 微信通过H5支付
 *               可以在浏览器调起微信支付
 * @param {type}
 * @return:
 */
export function payByWeixinH5() {
  window.location.href = "";
}

/**
 * payByThirdPartyCashier
 * @description: 第三方收银台
 * @param {type}
 * @return:
 */
export function payByThirdPartyCashier() {
  window.location.href = "";
}
